/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive;

import java.util.concurrent.CompletableFuture;
import org.elastos.hive.AuthHelper;
import org.elastos.hive.Database;
import org.elastos.hive.DatabaseImpl;
import org.elastos.hive.Files;
import org.elastos.hive.FilesImpl;
import org.elastos.hive.KeyValues;
import org.elastos.hive.Payment;
import org.elastos.hive.PaymentImpl;
import org.elastos.hive.Scripting;
import org.elastos.hive.ScriptingImpl;
import org.elastos.hive.VaultHelper;
import org.elastos.hive.Version;
import org.elastos.hive.VersionImpl;

public class Vault {
    private Files files;
    private Database database;
    private Scripting scripting;
    private KeyValues keyValues;
    private Payment payment;
    private Version version;
    private String providerAddress;
    private String ownerDid;
    private AuthHelper authHelper;
    private VaultHelper vaultHelper;

    Vault(AuthHelper authHelper, String providerAddress, String ownerDid) {
        this.authHelper = authHelper;
        this.providerAddress = providerAddress;
        this.ownerDid = ownerDid;
        this.files = new FilesImpl(authHelper);
        this.database = new DatabaseImpl(authHelper);
        this.scripting = new ScriptingImpl(authHelper);
        this.payment = new PaymentImpl(authHelper);
        this.version = new VersionImpl(authHelper);
        this.vaultHelper = new VaultHelper(authHelper);
    }

    public CompletableFuture<String> getNodeVersion() {
        return this.version.getVersion();
    }

    public CompletableFuture<String> getNodeLastCommitId() {
        return this.version.getLastCommitId();
    }

    public String getProviderAddress() {
        return this.providerAddress;
    }

    public String getOwnerDid() {
        return this.ownerDid;
    }

    public String getAppId() {
        return this.authHelper.getAppId();
    }

    public String getAppInstanceDid() {
        return this.authHelper.getAppInstanceDid();
    }

    public String getUserDid() {
        return this.authHelper.getUserDid();
    }

    public Database getDatabase() {
        return this.database;
    }

    public Files getFiles() {
        return this.files;
    }

    public KeyValues getKeyValues() {
        return this.keyValues;
    }

    public Scripting getScripting() {
        return this.scripting;
    }

    public Payment getPayment() {
        return this.payment;
    }

    CompletableFuture<Vault> requestToCreateVault() {
        return this.vaultHelper.requestToCreateVault().thenApplyAsync(aBoolean -> aBoolean != false ? this : null);
    }

    CompletableFuture<Vault> checkVaultExist() {
        return this.vaultHelper.vaultExist().thenApplyAsync(aBoolean -> aBoolean != false ? null : this);
    }

    public void revokeAccessToken() {
        this.authHelper.removeToken();
    }
}

