/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.hive;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.elastos.hive.Persistent;
import org.elastos.hive.exception.HiveException;
import org.elastos.hive.utils.CryptoUtil;
import org.json.JSONObject;

class PersistentImpl
implements Persistent {
    private String ownerDid;
    private String provider;
    private String storePath;
    private String configPath;

    public PersistentImpl(String ownerDid, String provider, String storePath) {
        this.ownerDid = ownerDid.trim();
        this.provider = provider.trim();
        this.storePath = storePath;
    }

    @Override
    public JSONObject parseFrom() throws HiveException {
        InputStreamReader reader = null;
        try {
            int len;
            this.initialize();
            reader = new FileReader(this.configPath);
            char[] buf = new char[128];
            StringBuilder content = new StringBuilder();
            while ((len = reader.read(buf)) != -1) {
                content.append(new String(buf, 0, len));
            }
            if (content.length() > 0) {
                JSONObject jSONObject = new JSONObject(content.toString());
                return jSONObject;
            }
        }
        catch (Exception e) {
            throw new HiveException(e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return new JSONObject();
    }

    @Override
    public void upateContent(JSONObject conetnt) throws HiveException {
        OutputStreamWriter fileWriter = null;
        try {
            this.initialize();
            fileWriter = new FileWriter(this.configPath);
            fileWriter.write(conetnt.toString());
        }
        catch (Exception e) {
            throw new HiveException(e.getMessage());
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void deleteContent() {
        String fileName;
        String tokenPath = String.format("%s/%s", this.storePath, "token");
        File file = new File(tokenPath, fileName = CryptoUtil.getSHA256(this.ownerDid + this.provider));
        if (file.exists()) {
            file.delete();
        }
    }

    private void initialize() throws IOException {
        String tokenPath = String.format("%s/%s", this.storePath, "token");
        File rootDir = new File(tokenPath);
        if (!rootDir.exists()) {
            rootDir.mkdirs();
        }
        String fileName = CryptoUtil.getSHA256(this.ownerDid + this.provider);
        this.configPath = String.format("%s/%s", tokenPath, fileName);
        File config = new File(this.configPath);
        if (!config.exists()) {
            config.createNewFile();
        }
    }
}

