/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.node.AExpression;

final class PSubCallInvoke
extends AExpression {
    private final PainlessMethod method;
    private final Class<?> box;
    private final List<AExpression> arguments;

    PSubCallInvoke(Location location, PainlessMethod method, Class<?> box, List<AExpression> arguments) {
        super(location);
        this.method = Objects.requireNonNull(method);
        this.box = box;
        this.arguments = Objects.requireNonNull(arguments);
    }

    @Override
    void extractVariables(Set<String> variables) {
        throw this.createError(new IllegalStateException("Illegal tree structure."));
    }

    @Override
    void analyze(Locals locals) {
        for (int argument = 0; argument < this.arguments.size(); ++argument) {
            AExpression expression = this.arguments.get(argument);
            expression.expected = this.method.arguments.get(argument);
            expression.internal = true;
            expression.analyze(locals);
            this.arguments.set(argument, expression.cast(locals));
        }
        this.statement = true;
        this.actual = this.method.rtn;
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        if (this.box.isPrimitive()) {
            writer.box(MethodWriter.getType(this.box));
        }
        for (AExpression argument : this.arguments) {
            argument.write(writer, globals);
        }
        this.method.write(writer);
    }

    @Override
    public String toString() {
        return this.singleLineToStringWithOptionalArgs(this.arguments, this.prefix, this.method.name);
    }
}

