/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Locale;
import java.util.Map;
import org.elasticsearch.ingest.common.AbstractStringProcessor;

public final class UppercaseProcessor
extends AbstractStringProcessor {
    public static final String TYPE = "uppercase";

    UppercaseProcessor(String processorTag, String field, boolean ignoreMissing, String targetField) {
        super(processorTag, field, ignoreMissing, targetField);
    }

    public static String apply(String value) {
        return value.toUpperCase(Locale.ROOT);
    }

    protected String process(String value) {
        return UppercaseProcessor.apply(value);
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    extends AbstractStringProcessor.Factory {
        public Factory() {
            super(UppercaseProcessor.TYPE);
        }

        @Override
        protected UppercaseProcessor newProcessor(String tag, Map<String, Object> config, String field, boolean ignoreMissing, String targetField) {
            return new UppercaseProcessor(tag, field, ignoreMissing, targetField);
        }
    }
}

