/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import java.util.Locale;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.fielddata.AbstractBinaryDocValues;
import org.elasticsearch.index.fielddata.AbstractNumericDocValues;
import org.elasticsearch.index.fielddata.AbstractSortedDocValues;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;

public enum MultiValueMode implements Writeable
{
    SUM{

        @Override
        protected long pick(SortedNumericDocValues values) throws IOException {
            int count = values.docValueCount();
            long total = 0L;
            for (int index = 0; index < count; ++index) {
                total += values.nextValue();
            }
            return total;
        }

        @Override
        protected long pick(SortedNumericDocValues values, long missingValue, DocIdSetIterator docItr, int startDoc, int endDoc) throws IOException {
            int totalCount = 0;
            long totalValue = 0L;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    int count = values.docValueCount();
                    for (int index = 0; index < count; ++index) {
                        totalValue += values.nextValue();
                    }
                    totalCount += count;
                }
                doc = docItr.nextDoc();
            }
            return totalCount > 0 ? totalValue : missingValue;
        }

        @Override
        protected double pick(SortedNumericDoubleValues values) throws IOException {
            int count = values.docValueCount();
            double total = 0.0;
            for (int index = 0; index < count; ++index) {
                total += values.nextValue();
            }
            return total;
        }

        @Override
        protected double pick(SortedNumericDoubleValues values, double missingValue, DocIdSetIterator docItr, int startDoc, int endDoc) throws IOException {
            int totalCount = 0;
            double totalValue = 0.0;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    int count = values.docValueCount();
                    for (int index = 0; index < count; ++index) {
                        totalValue += values.nextValue();
                    }
                    totalCount += count;
                }
                doc = docItr.nextDoc();
            }
            return totalCount > 0 ? totalValue : missingValue;
        }
    }
    ,
    AVG{

        @Override
        protected long pick(SortedNumericDocValues values) throws IOException {
            int count = values.docValueCount();
            long total = 0L;
            for (int index = 0; index < count; ++index) {
                total += values.nextValue();
            }
            return count > 1 ? Math.round((double)total / (double)count) : total;
        }

        @Override
        protected long pick(SortedNumericDocValues values, long missingValue, DocIdSetIterator docItr, int startDoc, int endDoc) throws IOException {
            int totalCount = 0;
            long totalValue = 0L;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    int count = values.docValueCount();
                    for (int index = 0; index < count; ++index) {
                        totalValue += values.nextValue();
                    }
                    totalCount += count;
                }
                doc = docItr.nextDoc();
            }
            if (totalCount < 1) {
                return missingValue;
            }
            return totalCount > 1 ? Math.round((double)totalValue / (double)totalCount) : totalValue;
        }

        @Override
        protected double pick(SortedNumericDoubleValues values) throws IOException {
            int count = values.docValueCount();
            double total = 0.0;
            for (int index = 0; index < count; ++index) {
                total += values.nextValue();
            }
            return total / (double)count;
        }

        @Override
        protected double pick(SortedNumericDoubleValues values, double missingValue, DocIdSetIterator docItr, int startDoc, int endDoc) throws IOException {
            int totalCount = 0;
            double totalValue = 0.0;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    int count = values.docValueCount();
                    for (int index = 0; index < count; ++index) {
                        totalValue += values.nextValue();
                    }
                    totalCount += count;
                }
                doc = docItr.nextDoc();
            }
            if (totalCount < 1) {
                return missingValue;
            }
            return totalValue / (double)totalCount;
        }
    }
    ,
    MEDIAN{

        @Override
        protected long pick(SortedNumericDocValues values) throws IOException {
            int count = values.docValueCount();
            for (int i = 0; i < (count - 1) / 2; ++i) {
                values.nextValue();
            }
            if (count % 2 == 0) {
                return Math.round(((double)values.nextValue() + (double)values.nextValue()) / 2.0);
            }
            return values.nextValue();
        }

        @Override
        protected double pick(SortedNumericDoubleValues values) throws IOException {
            int count = values.docValueCount();
            for (int i = 0; i < (count - 1) / 2; ++i) {
                values.nextValue();
            }
            if (count % 2 == 0) {
                return (values.nextValue() + values.nextValue()) / 2.0;
            }
            return values.nextValue();
        }
    }
    ,
    MIN{

        @Override
        protected long pick(SortedNumericDocValues values) throws IOException {
            return values.nextValue();
        }

        @Override
        protected long pick(SortedNumericDocValues values, long missingValue, DocIdSetIterator docItr, int startDoc, int endDoc) throws IOException {
            boolean hasValue = false;
            long minValue = Long.MAX_VALUE;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    minValue = Math.min(minValue, values.nextValue());
                    hasValue = true;
                }
                doc = docItr.nextDoc();
            }
            return hasValue ? minValue : missingValue;
        }

        @Override
        protected double pick(SortedNumericDoubleValues values) throws IOException {
            return values.nextValue();
        }

        @Override
        protected double pick(SortedNumericDoubleValues values, double missingValue, DocIdSetIterator docItr, int startDoc, int endDoc) throws IOException {
            boolean hasValue = false;
            double minValue = Double.POSITIVE_INFINITY;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    minValue = Math.min(minValue, values.nextValue());
                    hasValue = true;
                }
                doc = docItr.nextDoc();
            }
            return hasValue ? minValue : missingValue;
        }

        @Override
        protected BytesRef pick(SortedBinaryDocValues values) throws IOException {
            return values.nextValue();
        }

        @Override
        protected BytesRef pick(BinaryDocValues values, BytesRefBuilder builder, DocIdSetIterator docItr, int startDoc, int endDoc) throws IOException {
            BytesRefBuilder value = null;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    BytesRef innerValue = values.binaryValue();
                    if (value == null) {
                        builder.copyBytes(innerValue);
                        value = builder;
                    } else {
                        BytesRef min;
                        BytesRef bytesRef = min = value.get().compareTo(innerValue) <= 0 ? value.get() : innerValue;
                        if (min == innerValue) {
                            value.copyBytes(min);
                        }
                    }
                }
                doc = docItr.nextDoc();
            }
            return value == null ? null : value.get();
        }

        @Override
        protected int pick(SortedSetDocValues values) throws IOException {
            return Math.toIntExact(values.nextOrd());
        }

        @Override
        protected int pick(SortedDocValues values, DocIdSetIterator docItr, int startDoc, int endDoc) throws IOException {
            int ord = Integer.MAX_VALUE;
            boolean hasValue = false;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    int innerOrd = values.ordValue();
                    ord = Math.min(ord, innerOrd);
                    hasValue = true;
                }
                doc = docItr.nextDoc();
            }
            return hasValue ? ord : -1;
        }
    }
    ,
    MAX{

        @Override
        protected long pick(SortedNumericDocValues values) throws IOException {
            int count = values.docValueCount();
            for (int i = 0; i < count - 1; ++i) {
                values.nextValue();
            }
            return values.nextValue();
        }

        @Override
        protected long pick(SortedNumericDocValues values, long missingValue, DocIdSetIterator docItr, int startDoc, int endDoc) throws IOException {
            boolean hasValue = false;
            long maxValue = Long.MIN_VALUE;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    int count = values.docValueCount();
                    for (int i = 0; i < count - 1; ++i) {
                        values.nextValue();
                    }
                    maxValue = Math.max(maxValue, values.nextValue());
                    hasValue = true;
                }
                doc = docItr.nextDoc();
            }
            return hasValue ? maxValue : missingValue;
        }

        @Override
        protected double pick(SortedNumericDoubleValues values) throws IOException {
            int count = values.docValueCount();
            for (int i = 0; i < count - 1; ++i) {
                values.nextValue();
            }
            return values.nextValue();
        }

        @Override
        protected double pick(SortedNumericDoubleValues values, double missingValue, DocIdSetIterator docItr, int startDoc, int endDoc) throws IOException {
            boolean hasValue = false;
            double maxValue = Double.NEGATIVE_INFINITY;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    int count = values.docValueCount();
                    for (int i = 0; i < count - 1; ++i) {
                        values.nextValue();
                    }
                    maxValue = Math.max(maxValue, values.nextValue());
                    hasValue = true;
                }
                doc = docItr.nextDoc();
            }
            return hasValue ? maxValue : missingValue;
        }

        @Override
        protected BytesRef pick(SortedBinaryDocValues values) throws IOException {
            int count = values.docValueCount();
            for (int i = 0; i < count - 1; ++i) {
                values.nextValue();
            }
            return values.nextValue();
        }

        @Override
        protected BytesRef pick(BinaryDocValues values, BytesRefBuilder builder, DocIdSetIterator docItr, int startDoc, int endDoc) throws IOException {
            BytesRefBuilder value = null;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    BytesRef innerValue = values.binaryValue();
                    if (value == null) {
                        builder.copyBytes(innerValue);
                        value = builder;
                    } else {
                        BytesRef max;
                        BytesRef bytesRef = max = value.get().compareTo(innerValue) > 0 ? value.get() : innerValue;
                        if (max == innerValue) {
                            value.copyBytes(max);
                        }
                    }
                }
                doc = docItr.nextDoc();
            }
            return value == null ? null : value.get();
        }

        @Override
        protected int pick(SortedSetDocValues values) throws IOException {
            long maxOrd = -1L;
            long ord = values.nextOrd();
            while (ord != -1L) {
                maxOrd = ord;
                ord = values.nextOrd();
            }
            return Math.toIntExact(maxOrd);
        }

        @Override
        protected int pick(SortedDocValues values, DocIdSetIterator docItr, int startDoc, int endDoc) throws IOException {
            int ord = -1;
            int doc = startDoc;
            while (doc < endDoc) {
                if (values.advanceExact(doc)) {
                    ord = Math.max(ord, values.ordValue());
                }
                doc = docItr.nextDoc();
            }
            return ord;
        }
    };


    public static MultiValueMode fromString(String sortMode) {
        try {
            return MultiValueMode.valueOf(sortMode.toUpperCase(Locale.ROOT));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal sort mode: " + sortMode);
        }
    }

    public NumericDocValues select(final SortedNumericDocValues values, final long missingValue) {
        final NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)values);
        if (singleton != null) {
            return new AbstractNumericDocValues(){
                private long value;

                public boolean advanceExact(int target) throws IOException {
                    this.value = singleton.advanceExact(target) ? singleton.longValue() : missingValue;
                    return true;
                }

                public int docID() {
                    return singleton.docID();
                }

                public long longValue() throws IOException {
                    return this.value;
                }
            };
        }
        return new AbstractNumericDocValues(){
            private long value;

            public boolean advanceExact(int target) throws IOException {
                this.value = values.advanceExact(target) ? MultiValueMode.this.pick(values) : missingValue;
                return true;
            }

            public int docID() {
                return values.docID();
            }

            public long longValue() throws IOException {
                return this.value;
            }
        };
    }

    protected long pick(SortedNumericDocValues values) throws IOException {
        throw new IllegalArgumentException("Unsupported sort mode: " + this);
    }

    public NumericDocValues select(final SortedNumericDocValues values, final long missingValue, final BitSet parentDocs, final DocIdSetIterator childDocs, int maxDoc) throws IOException {
        if (parentDocs == null || childDocs == null) {
            return this.select(DocValues.emptySortedNumeric((int)maxDoc), missingValue);
        }
        return new AbstractNumericDocValues(){
            int lastSeenParentDoc = -1;
            long lastEmittedValue = missingValue;

            public boolean advanceExact(int parentDoc) throws IOException {
                assert (parentDoc >= this.lastSeenParentDoc) : "can only evaluate current and upcoming parent docs";
                if (parentDoc == this.lastSeenParentDoc) {
                    return true;
                }
                if (parentDoc == 0) {
                    this.lastEmittedValue = missingValue;
                    return true;
                }
                int prevParentDoc = parentDocs.prevSetBit(parentDoc - 1);
                int firstChildDoc = childDocs.docID() > prevParentDoc ? childDocs.docID() : childDocs.advance(prevParentDoc + 1);
                this.lastSeenParentDoc = parentDoc;
                this.lastEmittedValue = MultiValueMode.this.pick(values, missingValue, childDocs, firstChildDoc, parentDoc);
                return true;
            }

            public int docID() {
                return this.lastSeenParentDoc;
            }

            public long longValue() {
                return this.lastEmittedValue;
            }
        };
    }

    protected long pick(SortedNumericDocValues values, long missingValue, DocIdSetIterator docItr, int startDoc, int endDoc) throws IOException {
        throw new IllegalArgumentException("Unsupported sort mode: " + this);
    }

    public NumericDoubleValues select(final SortedNumericDoubleValues values, final double missingValue) {
        final NumericDoubleValues singleton = FieldData.unwrapSingleton(values);
        if (singleton != null) {
            return new NumericDoubleValues(){
                private double value;

                public boolean advanceExact(int doc) throws IOException {
                    this.value = singleton.advanceExact(doc) ? singleton.doubleValue() : missingValue;
                    return true;
                }

                public double doubleValue() throws IOException {
                    return this.value;
                }
            };
        }
        return new NumericDoubleValues(){
            private double value;

            public boolean advanceExact(int target) throws IOException {
                this.value = values.advanceExact(target) ? MultiValueMode.this.pick(values) : missingValue;
                return true;
            }

            public double doubleValue() throws IOException {
                return this.value;
            }
        };
    }

    protected double pick(SortedNumericDoubleValues values) throws IOException {
        throw new IllegalArgumentException("Unsupported sort mode: " + this);
    }

    public NumericDoubleValues select(final SortedNumericDoubleValues values, final double missingValue, final BitSet parentDocs, final DocIdSetIterator childDocs, int maxDoc) throws IOException {
        if (parentDocs == null || childDocs == null) {
            return this.select(FieldData.emptySortedNumericDoubles(), missingValue);
        }
        return new NumericDoubleValues(){
            int lastSeenParentDoc = 0;
            double lastEmittedValue = missingValue;

            public boolean advanceExact(int parentDoc) throws IOException {
                assert (parentDoc >= this.lastSeenParentDoc) : "can only evaluate current and upcoming parent docs";
                if (parentDoc == this.lastSeenParentDoc) {
                    return true;
                }
                int prevParentDoc = parentDocs.prevSetBit(parentDoc - 1);
                int firstChildDoc = childDocs.docID() > prevParentDoc ? childDocs.docID() : childDocs.advance(prevParentDoc + 1);
                this.lastSeenParentDoc = parentDoc;
                this.lastEmittedValue = MultiValueMode.this.pick(values, missingValue, childDocs, firstChildDoc, parentDoc);
                return true;
            }

            public double doubleValue() throws IOException {
                return this.lastEmittedValue;
            }
        };
    }

    protected double pick(SortedNumericDoubleValues values, double missingValue, DocIdSetIterator docItr, int startDoc, int endDoc) throws IOException {
        throw new IllegalArgumentException("Unsupported sort mode: " + this);
    }

    public BinaryDocValues select(final SortedBinaryDocValues values, final BytesRef missingValue) {
        final BinaryDocValues singleton = FieldData.unwrapSingleton(values);
        if (singleton != null) {
            if (missingValue == null) {
                return singleton;
            }
            return new AbstractBinaryDocValues(){
                private BytesRef value;

                public boolean advanceExact(int target) throws IOException {
                    this.value = singleton.advanceExact(target) ? singleton.binaryValue() : missingValue;
                    return true;
                }

                public BytesRef binaryValue() throws IOException {
                    return this.value;
                }
            };
        }
        return new AbstractBinaryDocValues(){
            private BytesRef value;

            public boolean advanceExact(int target) throws IOException {
                if (values.advanceExact(target)) {
                    this.value = MultiValueMode.this.pick(values);
                    return true;
                }
                this.value = missingValue;
                return missingValue != null;
            }

            public BytesRef binaryValue() throws IOException {
                return this.value;
            }
        };
    }

    protected BytesRef pick(SortedBinaryDocValues values) throws IOException {
        throw new IllegalArgumentException("Unsupported sort mode: " + this);
    }

    public BinaryDocValues select(SortedBinaryDocValues values, final BytesRef missingValue, final BitSet parentDocs, final DocIdSetIterator childDocs, int maxDoc) throws IOException {
        if (parentDocs == null || childDocs == null) {
            return this.select(FieldData.emptySortedBinary(), missingValue);
        }
        final BinaryDocValues selectedValues = this.select(values, null);
        return new AbstractBinaryDocValues(){
            final BytesRefBuilder builder = new BytesRefBuilder();
            int lastSeenParentDoc = 0;
            BytesRef lastEmittedValue = missingValue;

            public boolean advanceExact(int parentDoc) throws IOException {
                assert (parentDoc >= this.lastSeenParentDoc) : "can only evaluate current and upcoming root docs";
                if (parentDoc == this.lastSeenParentDoc) {
                    return true;
                }
                int prevParentDoc = parentDocs.prevSetBit(parentDoc - 1);
                int firstChildDoc = childDocs.docID() > prevParentDoc ? childDocs.docID() : childDocs.advance(prevParentDoc + 1);
                this.lastSeenParentDoc = parentDoc;
                this.lastEmittedValue = MultiValueMode.this.pick(selectedValues, this.builder, childDocs, firstChildDoc, parentDoc);
                if (this.lastEmittedValue == null) {
                    this.lastEmittedValue = missingValue;
                }
                return true;
            }

            public BytesRef binaryValue() throws IOException {
                return this.lastEmittedValue;
            }
        };
    }

    protected BytesRef pick(BinaryDocValues values, BytesRefBuilder builder, DocIdSetIterator docItr, int startDoc, int endDoc) throws IOException {
        throw new IllegalArgumentException("Unsupported sort mode: " + this);
    }

    public SortedDocValues select(final SortedSetDocValues values) {
        if (values.getValueCount() >= Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("fields containing more than 2147483646 unique terms are unsupported");
        }
        SortedDocValues singleton = DocValues.unwrapSingleton((SortedSetDocValues)values);
        if (singleton != null) {
            return singleton;
        }
        return new AbstractSortedDocValues(){
            int ord;

            public boolean advanceExact(int target) throws IOException {
                if (values.advanceExact(target)) {
                    this.ord = MultiValueMode.this.pick(values);
                    return true;
                }
                this.ord = -1;
                return false;
            }

            public int docID() {
                return values.docID();
            }

            public int ordValue() {
                assert (this.ord != -1);
                return this.ord;
            }

            public BytesRef lookupOrd(int ord) throws IOException {
                return values.lookupOrd((long)ord);
            }

            public int getValueCount() {
                return (int)values.getValueCount();
            }
        };
    }

    protected int pick(SortedSetDocValues values) throws IOException {
        throw new IllegalArgumentException("Unsupported sort mode: " + this);
    }

    public SortedDocValues select(SortedSetDocValues values, final BitSet parentDocs, final DocIdSetIterator childDocs) throws IOException {
        if (parentDocs == null || childDocs == null) {
            return this.select(DocValues.emptySortedSet());
        }
        final SortedDocValues selectedValues = this.select(values);
        return new AbstractSortedDocValues(){
            int docID = -1;
            int lastSeenParentDoc = 0;
            int lastEmittedOrd = -1;

            public BytesRef lookupOrd(int ord) throws IOException {
                return selectedValues.lookupOrd(ord);
            }

            public int getValueCount() {
                return selectedValues.getValueCount();
            }

            public boolean advanceExact(int parentDoc) throws IOException {
                assert (parentDoc >= this.lastSeenParentDoc) : "can only evaluate current and upcoming root docs";
                if (parentDoc == this.lastSeenParentDoc) {
                    return this.lastEmittedOrd != -1;
                }
                int prevParentDoc = parentDocs.prevSetBit(parentDoc - 1);
                int firstChildDoc = childDocs.docID() > prevParentDoc ? childDocs.docID() : childDocs.advance(prevParentDoc + 1);
                this.docID = this.lastSeenParentDoc = parentDoc;
                this.lastEmittedOrd = MultiValueMode.this.pick(selectedValues, childDocs, firstChildDoc, parentDoc);
                return this.lastEmittedOrd != -1;
            }

            public int docID() {
                return this.docID;
            }

            public int ordValue() {
                return this.lastEmittedOrd;
            }
        };
    }

    protected int pick(SortedDocValues values, DocIdSetIterator docItr, int startDoc, int endDoc) throws IOException {
        throw new IllegalArgumentException("Unsupported sort mode: " + this);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(this);
    }

    public static MultiValueMode readMultiValueModeFrom(StreamInput in) throws IOException {
        return in.readEnum(MultiValueMode.class);
    }
}

