/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.UidIndexFieldData;
import org.elasticsearch.index.fielddata.plain.PagedBytesIndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TermBasedFieldType;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.indices.breaker.CircuitBreakerService;

public class UidFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_uid";
    public static final String CONTENT_TYPE = "_uid";
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(UidFieldMapper.class));

    static MappedFieldType defaultFieldType(IndexSettings indexSettings) {
        MappedFieldType defaultFieldType = Defaults.FIELD_TYPE.clone();
        if (indexSettings.isSingleType()) {
            defaultFieldType.setIndexOptions(IndexOptions.NONE);
            defaultFieldType.setStored(false);
        } else {
            defaultFieldType.setIndexOptions(IndexOptions.DOCS);
            defaultFieldType.setStored(true);
        }
        return defaultFieldType;
    }

    private UidFieldMapper(IndexSettings indexSettings, MappedFieldType existing) {
        this(existing == null ? UidFieldMapper.defaultFieldType(indexSettings) : existing, indexSettings);
    }

    private UidFieldMapper(MappedFieldType fieldType, IndexSettings indexSettings) {
        super("_uid", fieldType, UidFieldMapper.defaultFieldType(indexSettings), indexSettings.getSettings());
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
    }

    @Override
    public Mapper parse(ParseContext context) throws IOException {
        return null;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        if (this.fieldType.indexOptions() != IndexOptions.NONE || this.fieldType.stored()) {
            Field uid = new Field("_uid", Uid.createUid(context.sourceToParse().type(), context.sourceToParse().id()), (IndexableFieldType)this.fieldType);
            fields.add((IndexableField)uid);
        }
    }

    @Override
    protected String contentType() {
        return "_uid";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder;
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
    }

    static final class UidFieldType
    extends TermBasedFieldType {
        UidFieldType() {
        }

        protected UidFieldType(UidFieldType ref) {
            super(ref);
        }

        @Override
        public MappedFieldType clone() {
            return new UidFieldType(this);
        }

        @Override
        public String typeName() {
            return "_uid";
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(final String fullyQualifiedIndexName) {
            if (this.indexOptions() == IndexOptions.NONE) {
                return new IndexFieldData.Builder(){

                    @Override
                    public IndexFieldData<?> build(IndexSettings indexSettings, MappedFieldType fieldType, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService) {
                        DEPRECATION_LOGGER.deprecated("Fielddata access on the _uid field is deprecated, use _id instead", new Object[0]);
                        MappedFieldType idFieldType = mapperService.fullName("_id");
                        IndexFieldData<?> idFieldData = idFieldType.fielddataBuilder(fullyQualifiedIndexName).build(indexSettings, idFieldType, cache, breakerService, mapperService);
                        String type = mapperService.types().iterator().next();
                        return new UidIndexFieldData(indexSettings.getIndex(), type, idFieldData);
                    }
                };
            }
            return new PagedBytesIndexFieldData.Builder(0.0, 2.147483647E9, 0);
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            return new MatchAllDocsQuery();
        }

        @Override
        public Query termQuery(Object value, @Nullable QueryShardContext context) {
            return this.termsQuery(Arrays.asList(value), context);
        }

        @Override
        public Query termsQuery(List<?> values, @Nullable QueryShardContext context) {
            if (this.indexOptions() != IndexOptions.NONE) {
                return super.termsQuery(values, context);
            }
            Collection<String> indexTypes = context.getMapperService().types();
            if (indexTypes.isEmpty()) {
                return new MatchNoDocsQuery("No types");
            }
            assert (indexTypes.size() == 1);
            String expectedPrefix = indexTypes.iterator().next() + "#";
            ArrayList<BytesRef> ids = new ArrayList<BytesRef>();
            for (Object uid : values) {
                String uidString;
                if (uid instanceof BytesRef) {
                    uid = ((BytesRef)uid).utf8ToString();
                }
                if (!(uidString = uid.toString()).startsWith(expectedPrefix)) continue;
                String id = uidString.substring(expectedPrefix.length(), uidString.length());
                BytesRef encodedId = context.indexVersionCreated().onOrAfter(Version.V_6_0_0_beta1) ? Uid.encodeId(id) : new BytesRef((CharSequence)id);
                ids.add(encodedId);
            }
            return new TermInSetQuery("_id", ids);
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        @Override
        public MetadataFieldMapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            throw new MapperParsingException("_uid is not configurable");
        }

        @Override
        public MetadataFieldMapper getDefault(MappedFieldType fieldType, Mapper.TypeParser.ParserContext context) {
            IndexSettings indexSettings = context.mapperService().getIndexSettings();
            return new UidFieldMapper(indexSettings, fieldType);
        }
    }

    public static class Defaults {
        public static final String NAME = "_uid";
        public static final MappedFieldType FIELD_TYPE = new UidFieldType();
        public static final MappedFieldType NESTED_FIELD_TYPE;

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(true);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setName("_uid");
            FIELD_TYPE.freeze();
            NESTED_FIELD_TYPE = FIELD_TYPE.clone();
            NESTED_FIELD_TYPE.setStored(false);
            NESTED_FIELD_TYPE.freeze();
        }
    }
}

