/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.index.fielddata.AbstractNumericDocValues;
import org.elasticsearch.index.fielddata.AbstractSortedNumericDocValues;
import org.elasticsearch.index.fielddata.DocValueBits;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SingletonMultiGeoPointValues;
import org.elasticsearch.index.fielddata.SingletonSortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SingletonSortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.SortableLongBitsNumericDocValues;
import org.elasticsearch.index.fielddata.SortableLongBitsSortedNumericDocValues;
import org.elasticsearch.index.fielddata.SortableLongBitsToNumericDoubleValues;
import org.elasticsearch.index.fielddata.SortableLongBitsToSortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.SortingBinaryDocValues;

public enum FieldData {


    public static SortedBinaryDocValues emptySortedBinary() {
        return FieldData.singleton(DocValues.emptyBinary());
    }

    public static NumericDoubleValues emptyNumericDouble() {
        return new NumericDoubleValues(){

            public boolean advanceExact(int doc) throws IOException {
                return false;
            }

            public double doubleValue() throws IOException {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static SortedNumericDoubleValues emptySortedNumericDoubles() {
        return FieldData.singleton(FieldData.emptyNumericDouble());
    }

    public static GeoPointValues emptyGeoPoint() {
        return new GeoPointValues(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return false;
            }

            @Override
            public GeoPoint geoPointValue() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static MultiGeoPointValues emptyMultiGeoPoints() {
        return FieldData.singleton(FieldData.emptyGeoPoint());
    }

    public static DocValueBits docsWithValue(final SortedBinaryDocValues values) {
        return new DocValueBits(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return values.advanceExact(doc);
            }
        };
    }

    public static DocValueBits docsWithValue(final SortedSetDocValues docValues) {
        return new DocValueBits(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return docValues.advanceExact(doc);
            }
        };
    }

    public static DocValueBits docsWithValue(final MultiGeoPointValues pointValues) {
        return new DocValueBits(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return pointValues.advanceExact(doc);
            }
        };
    }

    public static DocValueBits docsWithValue(final SortedNumericDoubleValues doubleValues) {
        return new DocValueBits(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return doubleValues.advanceExact(doc);
            }
        };
    }

    public static DocValueBits docsWithValue(final SortedNumericDocValues docValues) {
        return new DocValueBits(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return docValues.advanceExact(doc);
            }
        };
    }

    public static SortedNumericDocValues toSortableLongBits(SortedNumericDoubleValues values) {
        NumericDoubleValues singleton = FieldData.unwrapSingleton(values);
        if (singleton != null) {
            Object longBits = singleton instanceof SortableLongBitsToNumericDoubleValues ? ((SortableLongBitsToNumericDoubleValues)singleton).getLongValues() : new SortableLongBitsNumericDocValues(singleton);
            return DocValues.singleton((NumericDocValues)longBits);
        }
        if (values instanceof SortableLongBitsToSortedNumericDoubleValues) {
            return ((SortableLongBitsToSortedNumericDoubleValues)values).getLongValues();
        }
        return new SortableLongBitsSortedNumericDocValues(values);
    }

    public static SortedNumericDoubleValues sortableLongBitsToDoubles(SortedNumericDocValues values) {
        NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)values);
        if (singleton != null) {
            NumericDoubleValues doubles = singleton instanceof SortableLongBitsNumericDocValues ? ((SortableLongBitsNumericDocValues)singleton).getDoubleValues() : new SortableLongBitsToNumericDoubleValues(singleton);
            return FieldData.singleton(doubles);
        }
        if (values instanceof SortableLongBitsSortedNumericDocValues) {
            return ((SortableLongBitsSortedNumericDocValues)values).getDoubleValues();
        }
        return new SortableLongBitsToSortedNumericDoubleValues(values);
    }

    public static SortedNumericDoubleValues castToDouble(SortedNumericDocValues values) {
        NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)values);
        if (singleton != null) {
            return FieldData.singleton(new DoubleCastedValues(singleton));
        }
        return new SortedDoubleCastedValues(values);
    }

    public static SortedNumericDocValues castToLong(SortedNumericDoubleValues values) {
        NumericDoubleValues singleton = FieldData.unwrapSingleton(values);
        if (singleton != null) {
            return DocValues.singleton((NumericDocValues)new LongCastedValues(singleton));
        }
        return new SortedLongCastedValues(values);
    }

    public static SortedNumericDoubleValues singleton(NumericDoubleValues values) {
        return new SingletonSortedNumericDoubleValues(values);
    }

    public static NumericDoubleValues unwrapSingleton(SortedNumericDoubleValues values) {
        if (values instanceof SingletonSortedNumericDoubleValues) {
            return ((SingletonSortedNumericDoubleValues)values).getNumericDoubleValues();
        }
        return null;
    }

    public static MultiGeoPointValues singleton(GeoPointValues values) {
        return new SingletonMultiGeoPointValues(values);
    }

    public static GeoPointValues unwrapSingleton(MultiGeoPointValues values) {
        if (values instanceof SingletonMultiGeoPointValues) {
            return ((SingletonMultiGeoPointValues)values).getGeoPointValues();
        }
        return null;
    }

    public static SortedBinaryDocValues singleton(BinaryDocValues values) {
        return new SingletonSortedBinaryDocValues(values);
    }

    public static BinaryDocValues unwrapSingleton(SortedBinaryDocValues values) {
        if (values instanceof SingletonSortedBinaryDocValues) {
            return ((SingletonSortedBinaryDocValues)values).getBinaryDocValues();
        }
        return null;
    }

    public static boolean isMultiValued(SortedSetDocValues values) {
        return DocValues.unwrapSingleton((SortedSetDocValues)values) == null;
    }

    public static boolean isMultiValued(SortedNumericDocValues values) {
        return DocValues.unwrapSingleton((SortedNumericDocValues)values) == null;
    }

    public static boolean isMultiValued(SortedNumericDoubleValues values) {
        return FieldData.unwrapSingleton(values) == null;
    }

    public static boolean isMultiValued(SortedBinaryDocValues values) {
        return FieldData.unwrapSingleton(values) != null;
    }

    public static boolean isMultiValued(MultiGeoPointValues values) {
        return FieldData.unwrapSingleton(values) == null;
    }

    public static SortedBinaryDocValues toString(final SortedNumericDocValues values) {
        return FieldData.toString(new ToStringValues(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return values.advanceExact(doc);
            }

            @Override
            public void get(List<CharSequence> list) throws IOException {
                int count = values.docValueCount();
                for (int i = 0; i < count; ++i) {
                    list.add(Long.toString(values.nextValue()));
                }
            }
        });
    }

    public static SortedBinaryDocValues toString(final SortedNumericDoubleValues values) {
        return FieldData.toString(new ToStringValues(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return values.advanceExact(doc);
            }

            @Override
            public void get(List<CharSequence> list) throws IOException {
                int count = values.docValueCount();
                for (int i = 0; i < count; ++i) {
                    list.add(Double.toString(values.nextValue()));
                }
            }
        });
    }

    public static SortedBinaryDocValues toString(final SortedSetDocValues values) {
        return new SortedBinaryDocValues(){
            private int count = 0;

            @Override
            public boolean advanceExact(int doc) throws IOException {
                if (!values.advanceExact(doc)) {
                    return false;
                }
                int i = 0;
                while (true) {
                    if (values.nextOrd() == -1L) break;
                    ++i;
                }
                this.count = i;
                boolean advanced = values.advanceExact(doc);
                assert (advanced);
                return true;
            }

            @Override
            public int docValueCount() {
                return this.count;
            }

            @Override
            public BytesRef nextValue() throws IOException {
                return values.lookupOrd(values.nextOrd());
            }
        };
    }

    public static SortedBinaryDocValues toString(final MultiGeoPointValues values) {
        return FieldData.toString(new ToStringValues(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return values.advanceExact(doc);
            }

            @Override
            public void get(List<CharSequence> list) throws IOException {
                int count = values.docValueCount();
                for (int i = 0; i < count; ++i) {
                    list.add(values.nextValue().toString());
                }
            }
        });
    }

    private static SortedBinaryDocValues toString(final ToStringValues toStringValues) {
        return new SortingBinaryDocValues(){
            final List<CharSequence> list = new ArrayList<CharSequence>();

            @Override
            public boolean advanceExact(int docID) throws IOException {
                if (!toStringValues.advanceExact(docID)) {
                    return false;
                }
                this.list.clear();
                toStringValues.get(this.list);
                this.count = this.list.size();
                this.grow();
                for (int i = 0; i < this.count; ++i) {
                    CharSequence s = this.list.get(i);
                    this.values[i].copyChars(s);
                }
                this.sort();
                return true;
            }
        };
    }

    private static class SortedLongCastedValues
    extends AbstractSortedNumericDocValues {
        private final SortedNumericDoubleValues values;

        SortedLongCastedValues(SortedNumericDoubleValues in) {
            this.values = in;
        }

        public boolean advanceExact(int target) throws IOException {
            return this.values.advanceExact(target);
        }

        public int docValueCount() {
            return this.values.docValueCount();
        }

        public long nextValue() throws IOException {
            return (long)this.values.nextValue();
        }
    }

    private static class LongCastedValues
    extends AbstractNumericDocValues {
        private final NumericDoubleValues values;
        private int docID = -1;

        LongCastedValues(NumericDoubleValues values) {
            this.values = values;
        }

        public boolean advanceExact(int target) throws IOException {
            this.docID = target;
            return this.values.advanceExact(target);
        }

        public long longValue() throws IOException {
            return (long)this.values.doubleValue();
        }

        public int docID() {
            return this.docID;
        }
    }

    private static class SortedDoubleCastedValues
    extends SortedNumericDoubleValues {
        private final SortedNumericDocValues values;

        SortedDoubleCastedValues(SortedNumericDocValues in) {
            this.values = in;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            return this.values.advanceExact(target);
        }

        @Override
        public double nextValue() throws IOException {
            return this.values.nextValue();
        }

        @Override
        public int docValueCount() {
            return this.values.docValueCount();
        }
    }

    private static class DoubleCastedValues
    extends NumericDoubleValues {
        private final NumericDocValues values;

        DoubleCastedValues(NumericDocValues values) {
            this.values = values;
        }

        public double doubleValue() throws IOException {
            return this.values.longValue();
        }

        public boolean advanceExact(int doc) throws IOException {
            return this.values.advanceExact(doc);
        }
    }

    private static interface ToStringValues {
        public boolean advanceExact(int var1) throws IOException;

        public void get(List<CharSequence> var1) throws IOException;
    }
}

