/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.similarities.Similarity;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.indices.mapper.MapperRegistry;
import org.elasticsearch.script.ScriptService;

public class MetaDataIndexUpgradeService
extends AbstractComponent {
    private final NamedXContentRegistry xContentRegistry;
    private final MapperRegistry mapperRegistry;
    private final IndexScopedSettings indexScopedSettings;
    private final UnaryOperator<IndexMetaData> upgraders;

    public MetaDataIndexUpgradeService(Settings settings, NamedXContentRegistry xContentRegistry, MapperRegistry mapperRegistry, IndexScopedSettings indexScopedSettings, Collection<UnaryOperator<IndexMetaData>> indexMetaDataUpgraders) {
        super(settings);
        this.xContentRegistry = xContentRegistry;
        this.mapperRegistry = mapperRegistry;
        this.indexScopedSettings = indexScopedSettings;
        this.upgraders = indexMetaData -> {
            IndexMetaData newIndexMetaData = indexMetaData;
            for (UnaryOperator upgrader : indexMetaDataUpgraders) {
                newIndexMetaData = (IndexMetaData)upgrader.apply(newIndexMetaData);
            }
            return newIndexMetaData;
        };
    }

    public IndexMetaData upgradeIndexMetaData(IndexMetaData indexMetaData, Version minimumIndexCompatibilityVersion) {
        if (this.isUpgraded(indexMetaData)) {
            return indexMetaData;
        }
        this.checkSupportedVersion(indexMetaData, minimumIndexCompatibilityVersion);
        IndexMetaData newMetaData = indexMetaData;
        newMetaData = this.archiveBrokenIndexSettings(newMetaData);
        this.checkMappingsCompatibility(newMetaData);
        newMetaData = (IndexMetaData)this.upgraders.apply(newMetaData);
        return this.markAsUpgraded(newMetaData);
    }

    boolean isUpgraded(IndexMetaData indexMetaData) {
        return indexMetaData.getUpgradedVersion().onOrAfter(Version.CURRENT);
    }

    private void checkSupportedVersion(IndexMetaData indexMetaData, Version minimumIndexCompatibilityVersion) {
        if (indexMetaData.getState() == IndexMetaData.State.OPEN && !MetaDataIndexUpgradeService.isSupportedVersion(indexMetaData, minimumIndexCompatibilityVersion)) {
            throw new IllegalStateException("The index [" + indexMetaData.getIndex() + "] was created with version [" + indexMetaData.getCreationVersion() + "] but the minimum compatible version is [" + minimumIndexCompatibilityVersion + "]. It should be re-indexed in Elasticsearch " + minimumIndexCompatibilityVersion.major + ".x before upgrading to " + Version.CURRENT + ".");
        }
    }

    private static boolean isSupportedVersion(IndexMetaData indexMetaData, Version minimumIndexCompatibilityVersion) {
        return indexMetaData.getCreationVersion().onOrAfter(minimumIndexCompatibilityVersion);
    }

    private void checkMappingsCompatibility(IndexMetaData indexMetaData) {
        try {
            IndexSettings indexSettings = new IndexSettings(indexMetaData, this.settings);
            AbstractMap<String, TriFunction<Settings, Version, ScriptService, Similarity>> similarityMap = new AbstractMap<String, TriFunction<Settings, Version, ScriptService, Similarity>>(){

                @Override
                public boolean containsKey(Object key) {
                    return true;
                }

                @Override
                public TriFunction<Settings, Version, ScriptService, Similarity> get(Object key) {
                    assert (key instanceof String) : "key must be a string but was: " + key.getClass();
                    return SimilarityService.BUILT_IN.get("BM25");
                }

                @Override
                public Set<Map.Entry<String, TriFunction<Settings, Version, ScriptService, Similarity>>> entrySet() {
                    return Collections.emptySet();
                }
            };
            SimilarityService similarityService = new SimilarityService(indexSettings, null, (Map<String, TriFunction<Settings, Version, ScriptService, Similarity>>)similarityMap);
            final NamedAnalyzer fakeDefault = new NamedAnalyzer("fake_default", AnalyzerScope.INDEX, new Analyzer(){

                protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                    throw new UnsupportedOperationException("shouldn't be here");
                }
            });
            AbstractMap<String, NamedAnalyzer> analyzerMap = new AbstractMap<String, NamedAnalyzer>(){

                @Override
                public NamedAnalyzer get(Object key) {
                    assert (key instanceof String) : "key must be a string but was: " + key.getClass();
                    return new NamedAnalyzer((String)key, AnalyzerScope.INDEX, fakeDefault.analyzer());
                }

                @Override
                public Set<Map.Entry<String, NamedAnalyzer>> entrySet() {
                    return Collections.emptySet();
                }
            };
            try (IndexAnalyzers fakeIndexAnalzyers = new IndexAnalyzers(indexSettings, fakeDefault, fakeDefault, fakeDefault, (Map<String, NamedAnalyzer>)analyzerMap, (Map<String, NamedAnalyzer>)analyzerMap);){
                MapperService mapperService = new MapperService(indexSettings, fakeIndexAnalzyers, this.xContentRegistry, similarityService, this.mapperRegistry, () -> null);
                mapperService.merge(indexMetaData, MapperService.MergeReason.MAPPING_RECOVERY, false);
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("unable to upgrade the mappings for the index [" + indexMetaData.getIndex() + "]", ex);
        }
    }

    private IndexMetaData markAsUpgraded(IndexMetaData indexMetaData) {
        Settings settings = Settings.builder().put(indexMetaData.getSettings()).put("index.version.upgraded", Version.CURRENT).build();
        return IndexMetaData.builder(indexMetaData).settings(settings).build();
    }

    IndexMetaData archiveBrokenIndexSettings(IndexMetaData indexMetaData) {
        Settings settings = indexMetaData.getSettings();
        Settings upgrade = this.indexScopedSettings.archiveUnknownOrInvalidSettings(settings, e -> this.logger.warn("{} ignoring unknown index setting: [{}] with value [{}]; archiving", (Object)indexMetaData.getIndex(), e.getKey(), e.getValue()), (e, ex) -> this.logger.warn(() -> new ParameterizedMessage("{} ignoring invalid index setting: [{}] with value [{}]; archiving", new Object[]{indexMetaData.getIndex(), e.getKey(), e.getValue()}), (Throwable)ex));
        if (upgrade != settings) {
            return IndexMetaData.builder(indexMetaData).settings(upgrade).build();
        }
        return indexMetaData;
    }
}

