/*
 * Decompiled with CFR 0.152.
 */
package org.eiichiro.gig.heroku;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.eiichiro.gig.heroku.PersistenceXMLProcessor;
import org.eiichiro.jazzmaster.Component;
import org.eiichiro.jazzmaster.lifecycle.Constructed;
import org.eiichiro.jazzmaster.lifecycle.Passivated;
import org.eiichiro.jazzmaster.scope.Singleton;
import org.eiichiro.reverb.system.Environment;
import org.postgresql.Driver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HerokuJPAEntityManagerFactory
extends Component<EntityManagerFactory> {
    private static final String DATABASE_URL = "DATABASE_URL";
    private static final String JDBC_DRIVER = "javax.persistence.jdbc.driver";
    private static final String JDBC_URL = "javax.persistence.jdbc.url";
    private static final String JDBC_USER = "javax.persistence.jdbc.user";
    private static final String JDBC_PASSWORD = "javax.persistence.jdbc.password";
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Map<String, String> properties = new HashMap<String, String>();
    private List<String> persistenceUnits = new ArrayList<String>();
    private Map<String, EntityManagerFactory> factories = new ConcurrentHashMap<String, EntityManagerFactory>();

    @Constructed
    public void configure() {
        String database = Environment.getenv((String)DATABASE_URL);
        if (database == null) {
            this.logger.warn("Environment variable [$DATABASE_URL] has not been specified; So you don't have access to the database service in this application");
        } else {
            this.logger.info("$DATABASE_URL is [" + database + "]");
            try {
                URI uri = new URI(database);
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put(JDBC_DRIVER, Driver.class.getName());
                properties.put(JDBC_URL, "jdbc:postgresql://" + uri.getHost() + uri.getPath());
                properties.put(JDBC_USER, uri.getUserInfo().split(":")[0]);
                properties.put(JDBC_PASSWORD, uri.getUserInfo().split(":")[1]);
                PersistenceXMLProcessor processor = new PersistenceXMLProcessor();
                processor.process();
                this.persistenceUnits = processor.persistenceUnits();
                this.properties = properties;
            }
            catch (Exception e) {
                this.logger.error("Failed to configure JPA's JDBC connection properties: $DATABASE_URL is [" + database + "]", (Throwable)e);
            }
        }
    }

    @Passivated
    public void close() {
        for (EntityManagerFactory factory : this.factories.values()) {
            factory.close();
        }
        this.persistenceUnits.clear();
        this.properties.clear();
    }

    public EntityManagerFactory instance() {
        if (!this.persistenceUnits.isEmpty()) {
            EntityManagerFactory factory = this.factories.get(this.persistenceUnits.get(0));
            if (factory == null) {
                factory = Persistence.createEntityManagerFactory((String)this.persistenceUnits.get(0), this.properties);
                this.factories.put(this.persistenceUnits.get(0), factory);
            }
            return factory;
        }
        this.logger.warn("Cannot access to the database service in this application; Returned 'EntityManagerFactory' instance is null");
        return null;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public List<String> persistenceUnits() {
        return this.persistenceUnits;
    }
}

