/*
 * Decompiled with CFR 0.152.
 */
package org.eiichiro.acidhouse.metamodel;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eiichiro.acidhouse.metamodel.Metamodel;
import org.eiichiro.reverb.lang.UncheckedException;

public class Property<E, T> {
    private final Metamodel<E> metamodel;
    private final Property<E, ?> parent;
    private final Type type;
    private final String name;
    private final List<String> path;

    public String name() {
        return this.name;
    }

    public Property(Metamodel<E> metamodel, Type type, String name) {
        this.metamodel = metamodel;
        this.parent = null;
        this.type = type;
        this.name = name;
        this.path = this.path(metamodel, name);
    }

    public Property(Property<E, ?> parent, Type type, String name) {
        this.metamodel = parent.metamodel();
        this.parent = parent;
        this.type = type;
        this.name = name;
        this.path = this.path(this.metamodel, name, parent.name());
    }

    public Metamodel<E> metamodel() {
        return this.metamodel;
    }

    public T get(Object entity) {
        Object value = entity;
        for (String name : this.path()) {
            try {
                Field field = value.getClass().getDeclaredField(name);
                field.setAccessible(true);
                value = field.get(value);
            }
            catch (Exception e) {
                throw new UncheckedException(e);
            }
        }
        return (T)value;
    }

    public void set(E entity, Object value) {
        Object object = entity;
        for (int i = 0; i < this.path().size() - 1; ++i) {
            try {
                Field field = object.getClass().getDeclaredField(this.path().get(i));
                field.setAccessible(true);
                object = field.get(object);
                continue;
            }
            catch (Exception e) {
                throw new UncheckedException(e);
            }
        }
        try {
            Field field = object.getClass().getDeclaredField(this.name);
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (Exception e) {
            throw new UncheckedException(e);
        }
    }

    public Property<E, ?> parent() {
        return this.parent;
    }

    public Type type() {
        return this.type;
    }

    public List<String> path() {
        return this.path;
    }

    private List<String> path(Metamodel<E> metamodel, String ... names) {
        ArrayList<String> path = new ArrayList<String>();
        for (String name : names) {
            path.add(name);
        }
        if (!metamodel.isRoot()) {
            path.add(metamodel.name());
        }
        for (Metamodel<?> parent = metamodel.parent(); parent != null && !parent.isRoot(); parent = parent.parent()) {
            path.add(parent.name());
        }
        Collections.reverse(path);
        return path;
    }
}

