/*
 * Decompiled with CFR 0.152.
 */
package org.eiichiro.acidhouse;

import java.util.Arrays;
import java.util.List;
import org.eiichiro.acidhouse.ComparableFilter;
import org.eiichiro.acidhouse.Filter;
import org.eiichiro.acidhouse.metamodel.ComparableProperty;
import org.eiichiro.acidhouse.metamodel.EmbeddedProperty;
import org.eiichiro.acidhouse.metamodel.Property;

public class InFilter<T extends Comparable<T>>
implements Filter<T> {
    private final Property<?, T> property;
    private final List<T> values;

    @SafeVarargs
    public InFilter(ComparableProperty<?, T> property, T ... values) {
        if (property == null) {
            throw new IllegalArgumentException("'property' must not be [" + property + "]");
        }
        if (values == null) {
            throw new IllegalArgumentException("'values' must not be [" + values + "]");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("Length of 'values' must be greater than [" + values.length + "]");
        }
        this.property = property;
        this.values = Arrays.asList(values);
    }

    public InFilter(ComparableProperty<?, T> property, List<T> values) {
        if (property == null) {
            throw new IllegalArgumentException("'property' must not be [" + property + "]");
        }
        if (values == null) {
            throw new IllegalArgumentException("'values' must not be [" + values + "]");
        }
        if (values.isEmpty()) {
            throw new IllegalArgumentException("Size of 'values' must be greater than [" + values.size() + "]");
        }
        this.property = property;
        this.values = values;
    }

    @Override
    public Property<?, T> property() {
        return this.property;
    }

    @Override
    public boolean matches(Object entity) {
        Comparable t = (Comparable)this.property.get(entity);
        for (Comparable value : this.values) {
            if (t.compareTo(value) != 0) continue;
            return true;
        }
        return false;
    }

    public List<T> values() {
        return this.values;
    }

    public String toString() {
        String name = this.property.parent() instanceof EmbeddedProperty ? this.property.parent().name() + "." + this.property.name() : this.property.name();
        StringBuilder builder = new StringBuilder("(");
        builder.append(name + " " + (Object)((Object)ComparableFilter.Operator.EQUAL_TO) + " " + this.toFilterString(this.values.get(0)));
        for (int i = 1; i < this.values.size(); ++i) {
            builder.append(" || " + name + " " + (Object)((Object)ComparableFilter.Operator.EQUAL_TO) + " " + this.toFilterString(this.values.get(i)));
        }
        return builder.append(")").toString();
    }

    private String toFilterString(Object object) {
        return object instanceof String ? "\"" + object + "\"" : object.toString();
    }
}

