/*
 * Decompiled with CFR 0.152.
 */
package org.eiichiro.acidhouse;

import org.eiichiro.acidhouse.Filter;
import org.eiichiro.acidhouse.metamodel.ComparableProperty;
import org.eiichiro.acidhouse.metamodel.EmbeddedProperty;
import org.eiichiro.acidhouse.metamodel.Property;

public class ComparableFilter<T extends Comparable<T>>
implements Filter<T> {
    private final Property<?, T> property;
    private final T value;
    private final Operator operator;

    public ComparableFilter(ComparableProperty<?, T> property, T value, Operator operator) {
        if (property == null) {
            throw new IllegalArgumentException("'property' must not be [" + property + "]");
        }
        this.property = property;
        this.value = value;
        this.operator = operator;
    }

    @Override
    public Property<?, T> property() {
        return this.property;
    }

    @Override
    public boolean matches(Object entity) {
        Comparable left = (Comparable)this.property.get(entity);
        return this.operator().matches(left.compareTo(this.value()));
    }

    public String toString() {
        T value = this.value();
        String string = value instanceof String ? "\"" + value + "\"" : value.toString();
        String name = this.property.parent() instanceof EmbeddedProperty ? this.property.parent().name() + "." + this.property.name() : this.property.name();
        return name + " " + (Object)((Object)this.operator()) + " " + string;
    }

    public Operator operator() {
        return this.operator;
    }

    public T value() {
        return this.value;
    }

    public static enum Operator {
        EQUAL_TO("=="){

            @Override
            public boolean matches(int compareTo) {
                return compareTo == 0;
            }
        }
        ,
        NOT_EQUAL_TO("!="){

            @Override
            public boolean matches(int compareTo) {
                return compareTo != 0;
            }
        }
        ,
        GREATER_THAN(">"){

            @Override
            public boolean matches(int compareTo) {
                return compareTo > 0;
            }
        }
        ,
        GREATER_THAN_OR_EQUAL_TO(">="){

            @Override
            public boolean matches(int compareTo) {
                return compareTo >= 0;
            }
        }
        ,
        LESS_THAN("<"){

            @Override
            public boolean matches(int compareTo) {
                return compareTo < 0;
            }
        }
        ,
        LESS_THAN_OR_EQUAL_TO("<="){

            @Override
            public boolean matches(int compareTo) {
                return compareTo <= 0;
            }
        };

        private final String expression;

        private Operator(String expression) {
            this.expression = expression;
        }

        abstract boolean matches(int var1);

        public String toString() {
            return this.expression;
        }
    }
}

