/*
 * Decompiled with CFR 0.152.
 */
package org.eiichiro.acidhouse;

import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import org.eiichiro.acidhouse.Aggregation;
import org.eiichiro.acidhouse.metamodel.Property;

public abstract class Aggregations {
    private Aggregations() {
    }

    public static <T extends Comparable<T>> Aggregation<T> max(Property<?, T> property) {
        return new Max<T>(property);
    }

    public static <T extends Comparable<T>> Aggregation<T> min(Property<?, T> property) {
        return new Min<T>(property);
    }

    public static <T extends Number> Aggregation<T> sum(Property<?, T> property) {
        return new Sum<T>(property);
    }

    private static class Sum<T extends Number>
    extends Aggregation<T> {
        private final Type type;

        public Sum(Property<?, T> property) {
            super(property);
            this.type = property.type();
        }

        @Override
        public T aggregate(List<T> list) {
            int i = 0;
            long l = 0L;
            double d = 0.0;
            short s = 0;
            float f = 0.0f;
            for (Number number : list) {
                if (this.type.equals(Integer.class)) {
                    i += number.intValue();
                    continue;
                }
                if (this.type.equals(Long.class)) {
                    l += number.longValue();
                    continue;
                }
                if (this.type.equals(Double.class)) {
                    d += number.doubleValue();
                    continue;
                }
                if (this.type.equals(Short.class)) {
                    s = (short)(s + number.shortValue());
                    continue;
                }
                f += number.floatValue();
            }
            Number object = this.type.equals(Integer.class) ? (Number)i : (Number)(this.type.equals(Long.class) ? (Number)l : (Number)(this.type.equals(Double.class) ? (Number)d : (Number)(this.type.equals(Short.class) ? (Number)s : (Number)Float.valueOf(f))));
            return (T)object;
        }
    }

    private static class Min<T extends Comparable<T>>
    extends Aggregation<T> {
        public Min(Property<?, T> property) {
            super(property);
        }

        @Override
        public T aggregate(List<T> list) {
            if (list.size() == 0) {
                return null;
            }
            Iterator<T> iterator = list.iterator();
            Comparable min = (Comparable)iterator.next();
            while (iterator.hasNext()) {
                Comparable next = (Comparable)iterator.next();
                if (next.compareTo(min) >= 0) continue;
                min = next;
            }
            return (T)min;
        }
    }

    private static class Max<T extends Comparable<T>>
    extends Aggregation<T> {
        public Max(Property<?, T> property) {
            super(property);
        }

        @Override
        public T aggregate(List<T> list) {
            if (list.size() == 0) {
                return null;
            }
            Iterator<T> iterator = list.iterator();
            Comparable max = (Comparable)iterator.next();
            while (iterator.hasNext()) {
                Comparable next = (Comparable)iterator.next();
                if (next.compareTo(max) <= 0) continue;
                max = next;
            }
            return (T)max;
        }
    }
}

