/*
 * Decompiled with CFR 0.152.
 */
package org.egolessness.cloud.registry;

import java.util.List;
import org.egolessness.cloud.ConditionalOnDestinoDiscoveryEnabled;
import org.egolessness.cloud.DestinoDiscoveryAutoConfiguration;
import org.egolessness.cloud.DestinoDiscoveryContext;
import org.egolessness.cloud.context.DestinoRegistrationCustomizer;
import org.egolessness.cloud.properties.DestinoDiscoveryProperties;
import org.egolessness.cloud.registry.DestinoAutoServiceRegistration;
import org.egolessness.cloud.registry.DestinoRegistration;
import org.egolessness.cloud.registry.DestinoServiceRegistry;
import org.egolessness.destino.client.DestinoConfiguration;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.reactive.context.ReactiveWebServerApplicationContext;
import org.springframework.boot.web.servlet.context.ServletWebServerApplicationContext;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationAutoConfiguration;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationProperties;
import org.springframework.cloud.client.serviceregistry.ServiceRegistryAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnDestinoDiscoveryEnabled
@ConditionalOnProperty(value={"spring.cloud.service-registry.auto-registration.enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={ServiceRegistryAutoConfiguration.class})
@AutoConfigureAfter(value={DestinoDiscoveryAutoConfiguration.class, AutoServiceRegistrationAutoConfiguration.class})
public class DestinoServiceRegistryAutoConfiguration {
    @Bean
    public DestinoServiceRegistry destinoServiceRegistry(DestinoConfiguration destinoConfiguration, DestinoDiscoveryProperties discoveryProperties) {
        return new DestinoServiceRegistry(destinoConfiguration, discoveryProperties);
    }

    @Bean
    @ConditionalOnBean(value={AutoServiceRegistrationProperties.class})
    public DestinoRegistration destinoRegistration(List<DestinoRegistrationCustomizer> registrationCustomizers, ObjectProvider<ServletWebServerApplicationContext> servletWebServerApplicationContextProvider, ObjectProvider<ReactiveWebServerApplicationContext> reactiveWebServerApplicationContextProvider, DestinoDiscoveryContext discoveryContext) {
        ServletWebServerApplicationContext servletApplicationContext = (ServletWebServerApplicationContext)servletWebServerApplicationContextProvider.getIfAvailable();
        ReactiveWebServerApplicationContext reactiveApplicationContext = (ReactiveWebServerApplicationContext)reactiveWebServerApplicationContextProvider.getIfAvailable();
        return new DestinoRegistration(discoveryContext, registrationCustomizers, servletApplicationContext, reactiveApplicationContext);
    }

    @Bean
    @ConditionalOnBean(value={AutoServiceRegistrationProperties.class})
    public DestinoAutoServiceRegistration destinoAutoServiceRegistration(DestinoServiceRegistry registry, AutoServiceRegistrationProperties autoServiceRegistrationProperties, DestinoRegistration registration) {
        return new DestinoAutoServiceRegistration(registry, autoServiceRegistrationProperties, registration);
    }
}

