/*
 * Decompiled with CFR 0.152.
 */
package org.egolessness.cloud.registry;

import java.util.List;
import org.egolessness.cloud.properties.DestinoDiscoveryProperties;
import org.egolessness.cloud.registry.DestinoRegistration;
import org.egolessness.destino.client.DestinoConfiguration;
import org.egolessness.destino.client.registration.ConsultationService;
import org.egolessness.destino.client.registration.RegistrationService;
import org.egolessness.destino.client.registration.message.RegistrationInfo;
import org.egolessness.destino.client.registration.selector.InstanceSelector;
import org.egolessness.destino.common.enumeration.RegisterMode;
import org.egolessness.destino.common.exception.DestinoException;
import org.egolessness.destino.common.model.ServiceInstance;
import org.egolessness.destino.common.utils.PredicateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.Status;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class DestinoServiceRegistry
implements ServiceRegistry<DestinoRegistration> {
    private static final Logger log = LoggerFactory.getLogger(DestinoServiceRegistry.class);
    private final DestinoDiscoveryProperties discoveryProperties;
    private final DestinoConfiguration destinoConfiguration;

    DestinoServiceRegistry(DestinoConfiguration destinoConfiguration, DestinoDiscoveryProperties discoveryProperties) {
        this.discoveryProperties = discoveryProperties;
        this.destinoConfiguration = destinoConfiguration;
    }

    public void register(DestinoRegistration registration) {
        if (!StringUtils.hasLength((String)registration.getServiceId())) {
            log.warn("No service register to destino server.");
            return;
        }
        RegistrationService registrationService = this.destinoConfiguration.getRegistrationService();
        String namespace = this.discoveryProperties.getNamespace();
        String group = this.discoveryProperties.getGroup();
        String serviceId = registration.getServiceId();
        RegistrationInfo registrationInfo = this.buildRegistrationInfo(registration);
        try {
            registrationService.register(namespace, group, serviceId, registrationInfo);
            log.info("Destino registry, {} {} {} {}:{} register finished.", new Object[]{namespace, group, serviceId, registrationInfo.getIp(), registrationInfo.getPort()});
        }
        catch (Exception e) {
            if (this.discoveryProperties.isFailFast()) {
                log.error("Destino registry, {} register failed...{},", new Object[]{serviceId, registration, e});
                ReflectionUtils.rethrowRuntimeException((Throwable)e);
            }
            log.warn("Destino registry fail-fast is false. {} register failed...{},", new Object[]{serviceId, registration, e});
        }
    }

    public void deregister(DestinoRegistration registration) {
        log.info("De-registering from destino server...");
        if (PredicateUtils.isEmpty((String)registration.getServiceId())) {
            log.warn("No dom to deregister from destino server...");
            return;
        }
        RegistrationService registrationService = this.destinoConfiguration.getRegistrationService();
        String namespace = this.discoveryProperties.getNamespace();
        String serviceId = registration.getServiceId();
        String group = this.discoveryProperties.getGroup();
        String clusterName = this.discoveryProperties.getClusterName();
        try {
            registrationService.deregister(namespace, group, serviceId, registration.getHost(), registration.getPort(), clusterName);
        }
        catch (Exception e) {
            log.error("ERR_DESTINY_DEREGISTER, deregister failed...{},", (Object)registration, (Object)e);
        }
        log.info("De-registration finished.");
    }

    public void setStatus(DestinoRegistration registration, String status) {
        if (!Status.UP.getCode().equalsIgnoreCase(status) && !Status.DOWN.getCode().equalsIgnoreCase(status)) {
            log.warn("Unsupported status {}, please choose UP or DOWN", (Object)status);
            return;
        }
        String namespace = this.discoveryProperties.getNamespace();
        String serviceId = registration.getServiceId();
        String group = this.discoveryProperties.getGroup();
        RegistrationInfo registrationInfo = this.buildRegistrationInfo(registration);
        registrationInfo.setEnabled(!Status.DOWN.getCode().equalsIgnoreCase(status));
        try {
            RegistrationService registrationService = this.destinoConfiguration.getRegistrationService();
            registrationService.update(namespace, group, serviceId, registrationInfo);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to update destino instance status.", e);
        }
    }

    public String getStatus(DestinoRegistration registration) {
        String namespace = this.discoveryProperties.getNamespace();
        String serviceId = registration.getServiceId();
        String group = this.discoveryProperties.getGroup();
        try {
            ConsultationService consultationService = this.destinoConfiguration.getConsultationService();
            InstanceSelector instanceSelector = consultationService.subscribeService(namespace, group, serviceId, new String[0]);
            List instances = instanceSelector.getAllInstances();
            for (ServiceInstance instance : instances) {
                if (!instance.getIp().equalsIgnoreCase(this.discoveryProperties.getIp()) || instance.getPort() != this.discoveryProperties.getPort()) continue;
                return instance.isEnabled() ? Status.UP.getCode() : Status.DOWN.getCode();
            }
        }
        catch (Exception e) {
            log.error("Failed to read instances of {}.", (Object)serviceId, (Object)e);
        }
        return null;
    }

    public void close() {
        try {
            this.destinoConfiguration.shutdown();
        }
        catch (DestinoException e) {
            log.error("Destino configuration shutdown failed.", (Throwable)e);
        }
    }

    private RegistrationInfo buildRegistrationInfo(DestinoRegistration registration) {
        RegistrationInfo registrationInfo = new RegistrationInfo();
        registrationInfo.setIp(registration.getHost());
        registrationInfo.setPort(registration.getPort());
        registrationInfo.setWeight((double)this.discoveryProperties.getWeight());
        registrationInfo.setEnabled(this.discoveryProperties.isInstanceEnabled());
        registrationInfo.setCluster(this.discoveryProperties.getClusterName());
        registrationInfo.setMetadata(registration.getMetadata());
        if (null != this.discoveryProperties.getRegisterMode()) {
            registrationInfo.setMode(this.discoveryProperties.getRegisterMode());
        } else if (this.discoveryProperties.isSafety()) {
            registrationInfo.setMode(RegisterMode.SAFETY);
        } else {
            registrationInfo.setMode(RegisterMode.QUICKLY);
        }
        registration.customize(registrationInfo);
        return registrationInfo;
    }
}

