/*
 * Decompiled with CFR 0.152.
 */
package org.egolessness.cloud.registry;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.egolessness.cloud.DestinoDiscoveryContext;
import org.egolessness.cloud.context.DestinoRegistrationCustomizer;
import org.egolessness.cloud.properties.DestinoDiscoveryProperties;
import org.egolessness.destino.client.registration.message.RegistrationInfo;
import org.springframework.boot.web.reactive.context.ReactiveWebServerApplicationContext;
import org.springframework.boot.web.servlet.context.ServletWebServerApplicationContext;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.serviceregistry.Registration;

public class DestinoRegistration
implements Registration {
    private final List<DestinoRegistrationCustomizer> registrationCustomizers;
    private final DestinoDiscoveryContext discoveryContext;
    private final ServletWebServerApplicationContext servletWebServerApplicationContext;
    private final ReactiveWebServerApplicationContext reactiveWebServerApplicationContext;

    public DestinoRegistration(DestinoDiscoveryContext discoveryContext, List<DestinoRegistrationCustomizer> destinoRegistrationCustomizers, ServletWebServerApplicationContext servletWebServerApplicationContext, ReactiveWebServerApplicationContext reactiveWebServerApplicationContext) {
        this.registrationCustomizers = destinoRegistrationCustomizers;
        this.discoveryContext = discoveryContext;
        this.servletWebServerApplicationContext = servletWebServerApplicationContext;
        this.reactiveWebServerApplicationContext = reactiveWebServerApplicationContext;
    }

    public String getServiceId() {
        return this.discoveryContext.getService();
    }

    public String getHost() {
        return this.discoveryContext.getHost();
    }

    public int getPort() {
        if (this.discoveryContext.getPort() > 0) {
            return this.discoveryContext.getPort();
        }
        if (this.servletWebServerApplicationContext != null) {
            return this.servletWebServerApplicationContext.getWebServer().getPort();
        }
        if (this.reactiveWebServerApplicationContext != null) {
            return this.reactiveWebServerApplicationContext.getWebServer().getPort();
        }
        return -1;
    }

    public void setPort(int port) {
        this.discoveryContext.setPort(port);
    }

    public boolean isSecure() {
        return this.discoveryContext.isSecure();
    }

    public URI getUri() {
        return DefaultServiceInstance.getUri((ServiceInstance)this);
    }

    public Map<String, String> getMetadata() {
        return this.discoveryContext.getMetadata();
    }

    public boolean isRegisterEnabled() {
        return this.discoveryContext.isRegisterEnabled();
    }

    public String getCluster() {
        return this.discoveryContext.getCluster();
    }

    public DestinoDiscoveryProperties getDiscoveryProperties() {
        return this.discoveryContext.getDiscoveryProperties();
    }

    public void customize(RegistrationInfo registrationInfo) {
        if (this.registrationCustomizers != null) {
            for (DestinoRegistrationCustomizer customizer : this.registrationCustomizers) {
                customizer.accept(registrationInfo);
            }
        }
    }

    public String toString() {
        return "DestinoRegistration{discoveryProperties=" + this.discoveryContext.getDiscoveryProperties() + '}';
    }
}

