/*
 * Decompiled with CFR 0.152.
 */
package org.egolessness.cloud.properties;

import org.egolessness.cloud.context.properties.DestinoPropertiesCompleter;
import org.egolessness.cloud.properties.DestinoDiscoveryProperties;
import org.egolessness.destino.client.properties.DestinoProperties;
import org.egolessness.destino.client.properties.LoggingProperties;
import org.egolessness.destino.common.utils.PredicateUtils;

public class DestinoDiscoveryPropertiesCompleter
implements DestinoPropertiesCompleter {
    private final DestinoDiscoveryProperties discoveryProperties;

    public DestinoDiscoveryPropertiesCompleter(DestinoDiscoveryProperties discoveryProperties) {
        this.discoveryProperties = discoveryProperties;
    }

    public void complete(DestinoProperties properties) {
        if (PredicateUtils.isNotEmpty(this.discoveryProperties.getAddress())) {
            for (String address : this.discoveryProperties.getAddress()) {
                properties.addAddress(address);
            }
        }
        if (PredicateUtils.isBlank((CharSequence)properties.getAddressesProviderUrl())) {
            properties.setAddressesProviderUrl(properties.getAddressesProviderUrl());
        }
        if (PredicateUtils.isEmpty((String)properties.getUsername())) {
            properties.setUsername(this.discoveryProperties.getUsername());
        }
        if (PredicateUtils.isEmpty((String)properties.getPassword())) {
            properties.setPassword(this.discoveryProperties.getPassword());
        }
        if (PredicateUtils.isEmpty((String)properties.getEncryptedPassword())) {
            properties.setEncryptedPassword(this.discoveryProperties.getEncryptedPassword());
        }
        if (PredicateUtils.isEmpty((String)properties.getAccessToken())) {
            properties.setAccessToken(this.discoveryProperties.getAccessToken());
        }
        if (PredicateUtils.isNotBlank((CharSequence)this.discoveryProperties.getLogLevel())) {
            LoggingProperties loggingProperties = properties.getLoggingProperties();
            if (null == loggingProperties) {
                loggingProperties = new LoggingProperties();
                properties.setLoggingProperties(loggingProperties);
            }
            loggingProperties.setRegistrationLogLevel(this.discoveryProperties.getLogLevel());
        }
    }

    public int getOrder() {
        return 1;
    }
}

