/*
 * Decompiled with CFR 0.152.
 */
package org.egolessness.cloud.loadbalancer;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.egolessness.cloud.DestinoDiscoveryContext;
import org.egolessness.cloud.context.util.InetAddressValidator;
import org.egolessness.destino.common.utils.PredicateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.EmptyResponse;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.loadbalancer.core.NoopServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ReactorServiceInstanceLoadBalancer;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import reactor.core.publisher.Mono;

public abstract class AbstractDestinoLoadBalancer
implements ReactorServiceInstanceLoadBalancer {
    private static final Logger log = LoggerFactory.getLogger(AbstractDestinoLoadBalancer.class);
    protected final String serviceId;
    protected final ObjectProvider<ServiceInstanceListSupplier> instanceListSupplierProvider;
    protected final DestinoDiscoveryContext discoveryContext;
    private boolean supportIpv6 = true;

    public AbstractDestinoLoadBalancer(ObjectProvider<ServiceInstanceListSupplier> instanceListSupplierProvider, String serviceId, DestinoDiscoveryContext discoveryContext) {
        this.serviceId = serviceId;
        this.instanceListSupplierProvider = instanceListSupplierProvider;
        this.discoveryContext = discoveryContext;
    }

    @PostConstruct
    public void init() {
        String iPv6Address = this.discoveryContext.getInetIPv6Utils().findIPv6Address();
        this.supportIpv6 = PredicateUtils.isNotEmpty((String)iPv6Address);
    }

    public Mono<Response<ServiceInstance>> choose(Request request) {
        ServiceInstanceListSupplier supplier = (ServiceInstanceListSupplier)this.instanceListSupplierProvider.getIfAvailable(NoopServiceInstanceListSupplier::new);
        return supplier.get(request).next().map(this::convertInstanceResponse);
    }

    private Response<ServiceInstance> convertInstanceResponse(List<ServiceInstance> instances) {
        if (PredicateUtils.isEmpty(instances)) {
            log.warn("No available instances for service: " + this.serviceId);
            return new EmptyResponse();
        }
        try {
            Stream<ServiceInstance> sameClusterInstances;
            String cluster = this.discoveryContext.getCluster();
            if (PredicateUtils.isNotBlank((CharSequence)cluster) && (sameClusterInstances = instances.stream().filter(instance -> Objects.equals(instance.getMetadata().get("instance.cluster"), cluster))).findAny().isPresent()) {
                instances = sameClusterInstances.collect(Collectors.toList());
            }
            if (PredicateUtils.isEmpty(instances = this.filterIpv6WhenUnsupported(instances))) {
                return new EmptyResponse();
            }
            return new DefaultResponse(this.chooseInstance(instances));
        }
        catch (Exception e) {
            log.warn("Failed to choose instance by destino Load balancer.", (Throwable)e);
            return null;
        }
    }

    protected double getWeight(ServiceInstance instance) {
        Map metadata = instance.getMetadata();
        String weightValue = (String)metadata.get("instance.weight");
        try {
            if (PredicateUtils.isNotEmpty((String)weightValue)) {
                return Double.parseDouble(weightValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1.0;
    }

    private List<ServiceInstance> filterIpv6WhenUnsupported(List<ServiceInstance> instances) {
        if (this.supportIpv6) {
            return instances;
        }
        return instances.stream().filter(instance -> !InetAddressValidator.isValidInet6Address((String)instance.getHost())).collect(Collectors.toList());
    }

    protected abstract ServiceInstance chooseInstance(List<ServiceInstance> var1);
}

