/*
 * Decompiled with CFR 0.152.
 */
package org.egolessness.cloud.instance;

import java.util.HashMap;
import java.util.function.BiFunction;
import org.egolessness.cloud.instance.DestinoServiceInstance;
import org.egolessness.destino.common.enumeration.Mark;
import org.egolessness.destino.common.model.ServiceInstance;
import org.egolessness.destino.common.utils.PredicateUtils;

public enum DestinoInstanceConverter implements BiFunction<ServiceInstance, String, DestinoServiceInstance>
{
    INSTANCE;


    @Override
    public DestinoServiceInstance apply(ServiceInstance instance, String serviceId) {
        DestinoServiceInstance destinoServiceInstance = new DestinoServiceInstance();
        destinoServiceInstance.setServiceId(serviceId);
        destinoServiceInstance.setHost(instance.getIp());
        destinoServiceInstance.setPort(instance.getPort());
        String instanceId = Mark.UNDERLINE.join(instance.getServiceName(), new Object[]{instance.getCluster(), instance.getIp(), instance.getPort()});
        destinoServiceInstance.setInstanceId(instanceId);
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("instance.weight", Double.toString(instance.getWeight()));
        metadata.put("instance.healthy", Boolean.toString(instance.isHealthy()));
        if (PredicateUtils.isNotBlank((CharSequence)instance.getCluster())) {
            metadata.put("instance.cluster", instance.getCluster());
        }
        if (null != instance.getMode()) {
            metadata.put("instance.register-mode", instance.getMode().name());
        }
        if (null != instance.getMetadata()) {
            metadata.putAll(instance.getMetadata());
        }
        destinoServiceInstance.setMetadata(metadata);
        String secureString = (String)metadata.get("secure");
        if (PredicateUtils.isNotBlank((CharSequence)secureString)) {
            boolean secure = Boolean.parseBoolean(secureString);
            destinoServiceInstance.setSecure(secure);
        }
        return destinoServiceInstance;
    }
}

