/*
 * Decompiled with CFR 0.152.
 */
package org.egolessness.cloud.endpoint;

import java.util.concurrent.TimeoutException;
import org.egolessness.destino.client.DestinoConfiguration;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class DestinoHealthIndicator
extends AbstractHealthIndicator {
    private final DestinoConfiguration destinoConfiguration;

    public DestinoHealthIndicator(DestinoConfiguration destinoConfiguration) {
        this.destinoConfiguration = destinoConfiguration;
    }

    protected void doHealthCheck(Health.Builder builder) {
        try {
            boolean available = this.destinoConfiguration.serverCheck();
            if (available) {
                builder.up();
            } else {
                builder.down();
            }
        }
        catch (TimeoutException e) {
            builder.unknown();
        }
    }
}

