/*
 * Decompiled with CFR 0.152.
 */
package org.egolessness.cloud.discovery.refresh;

import java.time.Duration;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.egolessness.cloud.properties.DestinoDiscoveryProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class DestinoDiscoveryHeartbeatRefresher
implements ApplicationEventPublisherAware,
SmartLifecycle {
    private static final Logger log = LoggerFactory.getLogger(DestinoDiscoveryHeartbeatRefresher.class);
    private final DestinoDiscoveryProperties discoveryProperties;
    private final ThreadPoolTaskScheduler taskScheduler;
    private final AtomicLong heartbeatIndex = new AtomicLong();
    private final AtomicBoolean started = new AtomicBoolean();
    private ApplicationEventPublisher publisher;
    private ScheduledFuture<?> heartbeatFuture;

    public DestinoDiscoveryHeartbeatRefresher(DestinoDiscoveryProperties discoveryProperties) {
        this.discoveryProperties = discoveryProperties;
        this.taskScheduler = this.buildTaskScheduler();
    }

    private ThreadPoolTaskScheduler buildTaskScheduler() {
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        taskScheduler.setBeanName("Destino-Heartbeat-Refresher");
        taskScheduler.initialize();
        return taskScheduler;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public boolean isRunning() {
        return this.started.get();
    }

    public void start() {
        if (this.started.compareAndSet(false, true)) {
            log.info("Start destino heartbeat task scheduler.");
            this.heartbeatFuture = this.taskScheduler.scheduleWithFixedDelay(this::publishHeartbeatEvent, Duration.ofMillis(this.discoveryProperties.getHeartbeatRefreshInterval()));
        }
    }

    public void stop() {
        if (this.started.compareAndSet(true, false) && this.heartbeatFuture != null) {
            this.taskScheduler.shutdown();
            this.heartbeatFuture.cancel(true);
        }
    }

    public void setApplicationEventPublisher(@NonNull ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    private void publishHeartbeatEvent() {
        try {
            this.publisher.publishEvent((ApplicationEvent)new HeartbeatEvent((Object)this, (Object)this.heartbeatIndex.getAndIncrement()));
        }
        catch (Exception e) {
            log.error("Refresh destino service error.", (Throwable)e);
        }
    }
}

