/*
 * Decompiled with CFR 0.152.
 */
package org.egolessness.cloud.discovery.reactive;

import java.util.Collections;
import java.util.List;
import org.egolessness.cloud.discovery.DestinoServiceDiscovery;
import org.egolessness.destino.common.exception.DestinoException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class DestinoReactiveDiscoveryClient
implements ReactiveDiscoveryClient {
    private static final Logger log = LoggerFactory.getLogger(DestinoReactiveDiscoveryClient.class);
    private final DestinoServiceDiscovery serviceDiscovery;

    public DestinoReactiveDiscoveryClient(DestinoServiceDiscovery destinoServiceDiscovery) {
        this.serviceDiscovery = destinoServiceDiscovery;
    }

    public String description() {
        return "Spring Cloud Reactive Discovery Client @Destino";
    }

    public Flux<ServiceInstance> getInstances(String serviceId) {
        return Mono.justOrEmpty((Object)serviceId).flatMapIterable(service -> {
            try {
                return this.serviceDiscovery.getInstances((String)service);
            }
            catch (Exception e) {
                log.error("Unable to read instances of serviceId: {} from destino server.", (Object)serviceId, (Object)e);
                return Collections.emptyList();
            }
        }).subscribeOn(Schedulers.boundedElastic());
    }

    public Flux<String> getServices() {
        return Flux.defer(() -> {
            try {
                List<String> services = this.serviceDiscovery.getServices();
                return Flux.fromIterable(services);
            }
            catch (DestinoException e) {
                log.error("Unable to read services from destino server.", (Throwable)e);
                return Flux.empty();
            }
        }).subscribeOn(Schedulers.boundedElastic());
    }
}

