/*
 * Decompiled with CFR 0.152.
 */
package org.egolessness.cloud.discovery;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.egolessness.cloud.instance.DestinoInstanceConverter;
import org.egolessness.cloud.properties.DestinoDiscoveryProperties;
import org.egolessness.destino.client.DestinoConfiguration;
import org.egolessness.destino.client.registration.selector.InstanceSelector;
import org.egolessness.destino.common.exception.DestinoException;
import org.egolessness.destino.common.model.Page;
import org.egolessness.destino.common.model.PageParam;
import org.egolessness.destino.common.model.Pageable;
import org.springframework.cloud.client.ServiceInstance;

public class DestinoServiceDiscovery {
    private final DestinoDiscoveryProperties discoveryProperties;
    private final DestinoConfiguration configuration;

    public DestinoServiceDiscovery(DestinoDiscoveryProperties discoveryProperties, DestinoConfiguration destinoConfiguration) {
        this.discoveryProperties = discoveryProperties;
        this.configuration = destinoConfiguration;
    }

    public List<ServiceInstance> getInstances(String serviceId) throws DestinoException {
        String namespace = this.discoveryProperties.getNamespace();
        String group = this.discoveryProperties.getGroup();
        InstanceSelector instancesSelector = this.configuration.getConsultationService().subscribeService(namespace, group, serviceId, new String[0]);
        return instancesSelector.getHealthyInstances().stream().filter(instance -> instance != null && instance.isEnabled() && instance.isHealthy()).map(instance -> DestinoInstanceConverter.INSTANCE.apply((org.egolessness.destino.common.model.ServiceInstance)instance, serviceId)).collect(Collectors.toList());
    }

    public List<String> getServices() throws DestinoException {
        PageParam pageParam = new PageParam(0, Integer.MAX_VALUE);
        Page<String> page = this.pageQueryServices((Pageable)pageParam);
        List services = page.getRecords();
        if (null != services) {
            return services;
        }
        return Collections.emptyList();
    }

    public Page<String> pageQueryServices(Pageable pageable) throws DestinoException {
        String namespace = this.discoveryProperties.getNamespace();
        String group = this.discoveryProperties.getGroup();
        return this.configuration.getConsultationService().queryServices(namespace, group, pageable);
    }
}

