/*
 * Decompiled with CFR 0.152.
 */
package org.egolessness.cloud.discovery;

import java.util.Collections;
import java.util.List;
import org.egolessness.cloud.discovery.DestinoServiceDiscovery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public class DestinoDiscoveryClient
implements DiscoveryClient {
    private static final Logger log = LoggerFactory.getLogger(DestinoDiscoveryClient.class);
    private final DestinoServiceDiscovery serviceDiscovery;

    public DestinoDiscoveryClient(DestinoServiceDiscovery destinoServiceDiscovery) {
        this.serviceDiscovery = destinoServiceDiscovery;
    }

    public String description() {
        return "Spring Cloud Discovery Client @Destino";
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        try {
            return this.serviceDiscovery.getInstances(serviceId);
        }
        catch (Exception e) {
            log.error("Unable to read instances of serviceId: {} from destino server.", (Object)serviceId, (Object)e);
            return Collections.emptyList();
        }
    }

    public List<String> getServices() {
        try {
            return this.serviceDiscovery.getServices();
        }
        catch (Exception e) {
            log.error("Unable to read services from destino server.", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

