/*
 * Decompiled with CFR 0.152.
 */
package org.egolessness.cloud;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.egolessness.cloud.context.util.InetIPv6Utils;
import org.egolessness.cloud.properties.DestinoDiscoveryProperties;
import org.egolessness.destino.common.constant.InstanceMetadataKey;
import org.egolessness.destino.common.utils.PredicateUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.client.discovery.ManagementServerPortUtils;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

public class DestinoDiscoveryContext {
    private final DestinoDiscoveryProperties discoveryProperties;
    private final ApplicationContext context;
    private final InetUtils inetUtils;
    private final InetIPv6Utils inetIPv6Utils;

    public DestinoDiscoveryContext(DestinoDiscoveryProperties discoveryProperties, ApplicationContext context, InetUtils inetUtils, InetIPv6Utils inetIPv6Utils) {
        this.discoveryProperties = discoveryProperties;
        this.context = context;
        this.inetUtils = inetUtils;
        this.inetIPv6Utils = inetIPv6Utils;
    }

    @PostConstruct
    public void init() throws Exception {
        Integer deathTimeout;
        Integer heartbeatTimeout;
        Integer heartbeatInterval;
        Integer managementPort;
        Environment env;
        String endpointBasePath;
        String ip;
        Map<String, String> metadata = this.discoveryProperties.getMetadata();
        if (null == metadata) {
            metadata = new HashMap<String, String>();
            this.discoveryProperties.setMetadata(metadata);
        }
        if (PredicateUtils.isNotBlank((CharSequence)this.discoveryProperties.getHealthCheckUrl())) {
            metadata.put(InstanceMetadataKey.HEALTH_CHECK_URL, this.discoveryProperties.getHealthCheckUrl());
        }
        metadata.put(InstanceMetadataKey.REGISTER_ENVIRONMENT, "SPRING_CLOUD");
        if (this.discoveryProperties.isSecure()) {
            metadata.put("secure", "true");
        }
        if (PredicateUtils.isBlank((CharSequence)(ip = this.discoveryProperties.getIp()))) {
            ip = this.findAvailableIp();
            this.discoveryProperties.setIp(ip);
        }
        if (PredicateUtils.isNotEmpty((String)(endpointBasePath = (env = this.context.getEnvironment()).getProperty("management.endpoints.web.base-path")))) {
            metadata.put("management.endpoints.web.base-path", endpointBasePath);
        }
        if ((managementPort = ManagementServerPortUtils.getPort((BeanFactory)this.context)) != null) {
            String contextPath;
            metadata.put("management.port", managementPort.toString());
            String address = env.getProperty("management.server.address");
            if (PredicateUtils.isNotEmpty((String)address)) {
                metadata.put("management.address", address);
            }
            if (PredicateUtils.isNotEmpty((String)(contextPath = env.getProperty("management.server.servlet.context-path")))) {
                metadata.put("management.context-path", contextPath);
            }
        }
        if ((heartbeatInterval = this.discoveryProperties.getHeartbeatInterval()) != null) {
            metadata.put(InstanceMetadataKey.HEARTBEAT_INTERVAL, Integer.toString(heartbeatInterval));
        }
        if ((heartbeatTimeout = this.discoveryProperties.getHeartbeatTimeout()) != null) {
            metadata.put(InstanceMetadataKey.HEARTBEAT_TIMEOUT, Integer.toString(heartbeatTimeout));
        }
        if ((deathTimeout = this.discoveryProperties.getDeathTimeout()) != null) {
            metadata.put(InstanceMetadataKey.DEATH_TIMEOUT, Integer.toString(deathTimeout));
        }
    }

    private String findAvailableIp() throws SocketException {
        String networkInterface = this.discoveryProperties.getNetworkInterface();
        if (PredicateUtils.isNotEmpty((String)networkInterface)) {
            NetworkInterface netInterface = NetworkInterface.getByName(networkInterface);
            if (null == netInterface) {
                throw new IllegalArgumentException("No such network interface: " + networkInterface);
            }
            Enumeration<InetAddress> inetAddress = netInterface.getInetAddresses();
            while (inetAddress.hasMoreElements()) {
                InetAddress foundAddress = inetAddress.nextElement();
                if (foundAddress instanceof Inet4Address && !foundAddress.isLoopbackAddress()) {
                    return foundAddress.getHostAddress();
                }
                if (!(foundAddress instanceof Inet6Address) || foundAddress.isLoopbackAddress()) continue;
                return foundAddress.getHostAddress();
            }
            throw new RuntimeException("Unable to find any available ip with network-interface: " + networkInterface);
        }
        String ipType = this.discoveryProperties.getIpType();
        if (PredicateUtils.isEmpty((String)ipType)) {
            String ipv4Address = this.inetUtils.findFirstNonLoopbackHostInfo().getIpAddress();
            String ipv6Address = this.inetIPv6Utils.findIPv6Address();
            if (PredicateUtils.isNotBlank((CharSequence)ipv6Address)) {
                this.discoveryProperties.getMetadata().put("IPv6", ipv6Address);
            }
            return ipv4Address;
        }
        if ("IPv4".equalsIgnoreCase(ipType)) {
            return this.inetUtils.findFirstNonLoopbackHostInfo().getIpAddress();
        }
        if ("IPv6".equalsIgnoreCase(ipType)) {
            String ipv6Address = this.inetIPv6Utils.findIPv6Address();
            if (PredicateUtils.isBlank((CharSequence)ipv6Address)) {
                return this.inetUtils.findFirstNonLoopbackHostInfo().getIpAddress();
            }
            return ipv6Address;
        }
        throw new IllegalArgumentException("Please check destino ip-type: " + ipType);
    }

    public String getService() {
        return this.discoveryProperties.getService();
    }

    public String getHost() {
        return this.discoveryProperties.getIp();
    }

    public int getPort() {
        return this.discoveryProperties.getPort();
    }

    public void setPort(int port) {
        this.discoveryProperties.setPort(port);
    }

    public boolean isSecure() {
        return this.discoveryProperties.isSecure();
    }

    public Map<String, String> getMetadata() {
        return this.discoveryProperties.getMetadata();
    }

    public String getNamespace() {
        return this.discoveryProperties.getNamespace();
    }

    public String getGroup() {
        return this.discoveryProperties.getGroup();
    }

    public boolean isRegisterEnabled() {
        return this.discoveryProperties.isRegisterEnabled();
    }

    public String getCluster() {
        return this.discoveryProperties.getClusterName();
    }

    public float getWeight() {
        return this.discoveryProperties.getWeight();
    }

    public DestinoDiscoveryProperties getDiscoveryProperties() {
        return this.discoveryProperties;
    }

    public InetIPv6Utils getInetIPv6Utils() {
        return this.inetIPv6Utils;
    }
}

