/*
 * Decompiled with CFR 0.152.
 */
package org.efaps.maven.plugin;

import java.io.File;
import java.net.MalformedURLException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.efaps.maven.plugin.EFapsAbstractMojo;
import org.efaps.update.FileType;
import org.efaps.update.Install;
import org.efaps.update.util.InstallationException;
import org.efaps.util.EFapsException;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;

@MojoGoal(value="updateFromFile")
public class UpdateFromFileMojo
extends EFapsAbstractMojo {
    @MojoParameter(required=true)
    private File file;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.init();
            this.reloadCache();
            this.startTransaction();
            String ending = this.file.getName().substring(this.file.getName().lastIndexOf(".") + 1);
            FileType filetype = FileType.getFileTypeByExensione((String)ending);
            Install install = new Install();
            install.addFile(this.file.toURI().toURL(), filetype.getType());
            install.updateLatest();
            this.commitTransaction();
        }
        catch (EFapsException e) {
            throw new MojoFailureException("import failed for file: " + this.file.getName() + "; " + e.toString());
        }
        catch (MalformedURLException e) {
            throw new MojoFailureException("import failed for file: " + this.file.getName() + "; " + e.toString());
        }
        catch (InstallationException e) {
            throw new MojoFailureException("import failed for file: " + this.file.getName() + "; " + e.toString());
        }
    }
}

