/*
 * Copyright 2003 - 2009 The eFaps Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Revision:        $Rev: 5657 $
 * Last Changed:    $Date: 2010-10-12 08:21:56 -0500 (Tue, 12 Oct 2010) $
 * Last Changed By: $Author: jan.moxter $
 */

package org.efaps.maven.plugin.install;

import org.apache.maven.plugin.MojoExecutionException;
import org.efaps.update.version.Application;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoRequiresDependencyResolution;

/**
 * Makes an update of an eFaps application for the last version of the
 * application.
 *
 * @author The eFaps Team
 * @version $Id: UpdateMojo.java 5657 2010-10-12 13:21:56Z jan.moxter $
 */
@MojoGoal(value = "update")
@MojoRequiresDependencyResolution(value = "compile")
public final class UpdateMojo
    extends AbstractEFapsInstallMojo
{
    /**
     * Executes the update goal.
     *
     * @throws MojoExecutionException if update failed
     */
    public void execute()
        throws MojoExecutionException
    {
        init();
        try  {
            final Application appl = Application.getApplicationFromClassPath(getApplications(),
                                                                             getClasspathElements());

            // update applications
            appl.updateLastVersion(getUserName(), getPassWord());
        } catch (final Exception e)  {
            throw new MojoExecutionException("Could not execute Installation script", e);
        }
    }
}
