/*
 * Decompiled with CFR 0.152.
 */
package org.efaps.maven.plugin.install;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.DirectoryScanner;
import org.efaps.maven.logger.SLF4JOverMavenLog;
import org.efaps.maven_java5.org.apache.maven.tools.plugin.Goal;
import org.efaps.maven_java5.org.apache.maven.tools.plugin.Parameter;
import org.efaps.maven_java5.org.apache.maven.tools.plugin.lifecycle.Phase;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

@Goal(name="generate-ciclass", requiresDependencyResolutionScope="compile", defaultPhase=Phase.GENERATE_SOURCES)
public class GenerateCIClassMojo
implements Mojo {
    private Log log = null;
    private final StringBuilder java = new StringBuilder();
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${basedir}/src/main/efaps/DataModels")
    private File sourceDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/ci")
    private File outputDirectory;
    @Parameter(required=true)
    private String ciName;
    @Parameter(required=true, defaultValue="org.efaps.esjp.ci")
    private String ciPackage;
    private final List<String> includes = null;
    private static final Set<String> DEFAULT_INCLUDES = new HashSet<String>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.init();
            this.initJavaFile();
            for (String fileName : this.getCopyFiles()) {
                File srcFile = new File(this.sourceDirectory, fileName);
                XMLReader reader = XMLReaderFactory.createXMLReader();
                reader.setContentHandler(new TypeHandler());
                FileInputStream stream = new FileInputStream(srcFile);
                reader.parse(new InputSource(stream));
                ((InputStream)stream).close();
            }
            this.closeJavaFile();
            this.outputDirectory.mkdir();
            String folders = this.ciPackage.replace(".", File.separator);
            File srcFolder = new File(this.outputDirectory, folders);
            srcFolder.mkdirs();
            File javaFile = new File(srcFolder, "CI" + this.ciName + ".java");
            FileUtils.writeStringToFile((File)javaFile, (String)this.java.toString());
            this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
        }
        catch (SAXException e) {
            this.getLog().error((CharSequence)"MojoExecutionException", (Throwable)e);
            throw new MojoExecutionException("SAXException");
        }
        catch (FileNotFoundException e) {
            this.getLog().error((CharSequence)"FileNotFoundException", (Throwable)e);
            throw new MojoExecutionException("SAXException");
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"IOException", (Throwable)e);
            throw new MojoExecutionException("SAXException");
        }
    }

    private void init() {
        try {
            Class.forName("org.efaps.maven.logger.SLF4JOverMavenLog");
            SLF4JOverMavenLog.LOGGER = this.getLog();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void closeJavaFile() {
        this.java.append("}\n");
    }

    private void initJavaFile() {
        this.java.append("//CHECKSTYLE:OFF\n").append("package ").append(this.ciPackage).append(";\n").append("import org.efaps.ci.CIAttribute;\n").append("import org.efaps.ci.CIType;\n").append("public final class CI").append(this.ciName).append("\n{\n");
    }

    protected String[] getCopyFiles() {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(this.sourceDirectory.toString());
        String[] included = this.includes == null ? DEFAULT_INCLUDES.toArray(new String[DEFAULT_INCLUDES.size()]) : this.includes.toArray(new String[this.includes.size()]);
        ds.setIncludes(included);
        ds.setCaseSensitive(true);
        ds.scan();
        return ds.getIncludedFiles();
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log _log) {
        this.log = _log;
    }

    static {
        DEFAULT_INCLUDES.add("**/*.xml");
    }

    public class TypeHandler
    extends DefaultHandler {
        private boolean called = false;
        private final List<String> attributes = new ArrayList<String>();
        private StringBuilder content = null;
        private boolean isCiType = false;
        private final Stack<String> tag = new Stack();
        private String typeName;
        private String uuid;
        private String parent;

        @Override
        public void startElement(String _namespaceURI, String _localName, String _qName, Attributes _atts) {
            if ("datamodel-type".equals(_qName) || "datamodel-statusgroup".equals(_qName)) {
                this.isCiType = true;
            }
            this.called = false;
            this.content = null;
            this.tag.push(_qName);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("name".equals(qName)) {
                if (this.tag.size() == 3) {
                    this.typeName = this.content.toString().trim();
                } else {
                    this.attributes.add(this.content.toString().trim());
                }
            } else if ("uuid".equals(qName)) {
                this.uuid = this.content.toString().trim();
            } else if ("parent".equals(qName)) {
                this.parent = this.content.toString().trim();
            }
            if (!this.called) {
                this.called = true;
                this.content = null;
            }
            if (!this.tag.isEmpty()) {
                this.tag.pop();
            }
        }

        @Override
        public void endDocument() throws SAXException {
            if (this.isCiType) {
                if (this.typeName.startsWith(GenerateCIClassMojo.this.ciName)) {
                    this.typeName = this.typeName.substring(this.typeName.indexOf("_") + 1);
                }
                String parentClass = "";
                if (this.parent != null) {
                    parentClass = this.parent.substring(0, this.parent.indexOf("_"));
                    this.parent = this.parent.substring(this.parent.indexOf("_") + 1);
                }
                GenerateCIClassMojo.this.java.append("public static final _").append(this.typeName).append(" ").append(this.typeName).append(" = new _").append(this.typeName).append("(\"").append(this.uuid).append("\");\n").append("public static class _").append(this.typeName).append(" extends ").append(this.parent == null ? "CIType" : "org.efaps.esjp.ci.CI" + parentClass + "._" + this.parent).append("\n{\n").append("    protected _").append(this.typeName).append("(final String _uuid)\n    {\n").append("        super(_uuid);").append("\n    }\n");
                for (String attribute : this.attributes) {
                    if ("Type".equals(attribute) || "OID".equals(attribute) || "ID".equals(attribute)) continue;
                    GenerateCIClassMojo.this.java.append("    public final CIAttribute ").append(attribute).append(" = new CIAttribute(this, \"").append(attribute).append("\");\n");
                }
                GenerateCIClassMojo.this.java.append("}\n\n");
            }
        }

        @Override
        public void characters(char[] _ch, int _start, int _length) throws SAXException {
            if (_length > 0) {
                String contentTmp = new String(_ch, _start, _length);
                if (!this.called && !this.tag.empty()) {
                    if (this.content == null) {
                        this.content = new StringBuilder();
                    }
                    this.content.append(contentTmp);
                }
            }
        }
    }
}

