/*
 * Copyright 2003 - 2009 The eFaps Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Revision:        $Rev: 4608 $
 * Last Changed:    $Date: 2010-05-29 10:56:34 -0500 (Sat, 29 May 2010) $
 * Last Changed By: $Author: jan.moxter $
 */

package org.efaps.maven.plugin.install;

import java.util.List;

import org.apache.maven.plugin.MojoExecutionException;
import org.efaps.maven_java5.org.apache.maven.tools.plugin.Goal;
import org.efaps.update.version.Application;

/**
 * Installs an eFaps application.
 *
 * @author The eFaps Team
 * @version $Id: SourceInstallMojo.java 4608 2010-05-29 15:56:34Z jan.moxter $
 */
@Goal(name = "source-install",
      requiresDependencyResolutionScope = "runtime")
public final class SourceInstallMojo
    extends AbstractEFapsInstallMojo
{
    /**
     * List of includes.
     */
    private final List<String> includes = null;

    /**
     * List of excludes.
     */
    private final List<String> excludes = null;

    /**
     * Executes the install goal.
     *
     * @throws MojoExecutionException if installation failed
     */
    public void execute()
        throws MojoExecutionException
    {
        init();

        try {
            final Application appl = Application.getApplicationFromSource(
                    getVersionFile(),
                    getClasspathElements(),
                    getEFapsDir(),
                    getOutputDirectory(),
                    this.includes,
                    this.excludes,
                    getTypeMapping());

            // install applications
            if (appl != null) {
                appl.install(getUserName(), getPassWord());
            }
        } catch (final Exception e) {
            throw new MojoExecutionException("Could not execute SourceInstall script", e);
        }
    }
}
