/*
 * Decompiled with CFR 0.152.
 */
package org.efaps.maven.plugin.install;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.DirectoryScanner;
import org.efaps.maven.plugin.EFapsAbstractMojo;
import org.efaps.maven_java5.org.apache.maven.tools.plugin.Parameter;
import org.efaps.update.FileType;

public abstract class AbstractEFapsInstallMojo
extends EFapsAbstractMojo {
    private static final Map<String, String> DEFAULT_TYPE_MAPPING = new HashMap<String, String>();
    private static final Set<String> DEFAULT_INCLUDES;
    private static final Set<String> DEFAULT_EXCLUDES;
    @Parameter(expression="${basedir}/src/main/efaps/versions.xml")
    private File versionFile;
    @Parameter(expression="${basedir}/src/main/efaps")
    private File eFapsDir;
    private final List<String> includes = null;
    private final List<String> excludes = null;
    private final Map<String, String> typeMapping = null;
    @Parameter(defaultValue="eFaps-Kernel")
    private String applications;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/ci")
    private File outputDirectory;

    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    protected List<String> getFiles() {
        ArrayList<String> ret = new ArrayList<String>();
        DirectoryScanner ds = new DirectoryScanner();
        String[] included = this.includes == null ? DEFAULT_INCLUDES.toArray(new String[DEFAULT_INCLUDES.size()]) : this.includes.toArray(new String[this.includes.size()]);
        String[] excluded = this.excludes == null ? DEFAULT_EXCLUDES.toArray(new String[DEFAULT_EXCLUDES.size()]) : this.excludes.toArray(new String[this.excludes.size()]);
        ds.setIncludes(included);
        ds.setExcludes(excluded);
        ds.setBasedir(this.getEFapsDir().toString());
        ds.setCaseSensitive(true);
        ds.scan();
        if (this.outputDirectory.exists()) {
            ret.addAll(Arrays.asList(ds.getIncludedFiles()));
            ds.setBasedir(this.outputDirectory);
            ds.scan();
        }
        ret.addAll(Arrays.asList(ds.getIncludedFiles()));
        return ret;
    }

    protected String getApplications() {
        return this.applications;
    }

    protected File getEFapsDir() {
        return this.eFapsDir;
    }

    protected Map<String, String> getTypeMapping() {
        return this.typeMapping == null ? DEFAULT_TYPE_MAPPING : this.typeMapping;
    }

    protected File getVersionFile() {
        return this.versionFile;
    }

    static {
        DEFAULT_TYPE_MAPPING.put("css", FileType.CSS.getType());
        DEFAULT_TYPE_MAPPING.put("java", FileType.JAVA.getType());
        DEFAULT_TYPE_MAPPING.put("js", FileType.JS.getType());
        DEFAULT_TYPE_MAPPING.put("jrxml", FileType.JRXML.getType());
        DEFAULT_TYPE_MAPPING.put("wiki", FileType.WIKI.getType());
        DEFAULT_TYPE_MAPPING.put("xml", FileType.XML.getType());
        DEFAULT_TYPE_MAPPING.put("xsl", FileType.XSL.getType());
        DEFAULT_INCLUDES = new HashSet<String>();
        DEFAULT_INCLUDES.add("**/*.css");
        DEFAULT_INCLUDES.add("**/*.java");
        DEFAULT_INCLUDES.add("**/*.js");
        DEFAULT_INCLUDES.add("**/*.jrxml");
        DEFAULT_INCLUDES.add("**/*.wiki");
        DEFAULT_INCLUDES.add("**/*.xml");
        DEFAULT_INCLUDES.add("**/*.xsl");
        DEFAULT_EXCLUDES = new HashSet<String>();
        DEFAULT_EXCLUDES.add("**/versions.xml");
    }
}

