/*
 * Decompiled with CFR 0.152.
 */
package org.efaps.maven.plugin.install;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.DirectoryScanner;
import org.efaps.maven.plugin.install.AbstractEFapsInstallMojo;
import org.efaps.maven_java5.org.apache.maven.tools.plugin.Goal;
import org.efaps.maven_java5.org.apache.maven.tools.plugin.Parameter;
import org.efaps.maven_java5.org.apache.maven.tools.plugin.lifecycle.Phase;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Goal(name="generate-installation", requiresDependencyResolutionScope="compile", defaultPhase=Phase.GENERATE_SOURCES)
public class GenerateInstallationMojo
extends AbstractEFapsInstallMojo {
    private static final String TAG_APPLICATION = "application";
    private static final String TAG_INSTALL = "install";
    private static final Set<String> DEFAULT_COPYINCLUDES = new HashSet<String>();
    private static final Set<String> DEFAULT_COPYEXCLUDES;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter
    private final List<String> copyIncludes = null;
    @Parameter
    private final List<String> copyExcludes = null;
    @Parameter(expression="${project.build.outputDirectory}")
    private File targetDirectory;
    @Parameter(defaultValue="META-INF/efaps/install.xml")
    private String targetInstallFile;
    @Parameter(defaultValue="UTF-8")
    private String targetEncoding;
    @Parameter(defaultValue="org/efaps/installations/applications")
    private String rootPackage;
    @Parameter(defaultValue="true")
    private boolean compile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.copyFiles(this.generateInstallFile());
        File esjpDir = new File(this.getEFapsDir(), "ESJP");
        if (this.compile && esjpDir.exists() && esjpDir.isDirectory()) {
            this.project.addCompileSourceRoot(new File(this.getEFapsDir(), "ESJP").getAbsolutePath());
        }
    }

    protected String generateInstallFile() throws MojoExecutionException, MojoFailureException {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(this.getVersionFile());
            NodeList nodeList = doc.getElementsByTagName(TAG_INSTALL);
            Node installNode = nodeList.item(0);
            NodeList subNodeList = installNode.getChildNodes();
            String application = null;
            for (int idx = 0; idx < subNodeList.getLength(); ++idx) {
                Node subNode = subNodeList.item(idx);
                if (1 != subNode.getNodeType() || !TAG_APPLICATION.equals(subNode.getNodeName())) continue;
                Node subSubNode = subNode.getFirstChild();
                if (3 != subSubNode.getNodeType()) break;
                application = subSubNode.getNodeValue();
                break;
            }
            if (application == null) {
                throw new MojoFailureException("Application name in '" + this.getVersionFile() + "' not given");
            }
            application = application.trim();
            String rootPackageTmp = this.rootPackage.replaceAll("/*$", "").replaceAll("^/*", "") + "/" + application + "/";
            Element rootPackageName = doc.createElement("rootPackage");
            installNode.appendChild(rootPackageName);
            Attr packAttr = doc.createAttribute("name");
            packAttr.setValue(rootPackageTmp);
            rootPackageName.getAttributes().setNamedItem(packAttr);
            Element files = doc.createElement("files");
            installNode.appendChild(files);
            TreeSet<String> filesSet = new TreeSet<String>(Arrays.asList(this.getFiles()));
            for (String fileName : filesSet) {
                Element file = doc.createElement("file");
                Attr typeAttr = doc.createAttribute("type");
                String type = this.getTypeMapping().get(fileName.substring(fileName.lastIndexOf(".") + 1));
                if (type == null) {
                    typeAttr.setValue("unknown");
                } else {
                    typeAttr.setValue(type);
                }
                file.getAttributes().setNamedItem(typeAttr);
                Attr fileAttr = doc.createAttribute("name");
                fileAttr.setValue(rootPackageTmp + fileName);
                file.getAttributes().setNamedItem(fileAttr);
                files.appendChild(file);
            }
            File targetInstallFileTmp = new File(this.targetDirectory, this.targetInstallFile);
            File parentDir = targetInstallFileTmp.getParentFile();
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            FileOutputStream os = new FileOutputStream(targetInstallFileTmp);
            StreamResult result = new StreamResult(new OutputStreamWriter((OutputStream)os, this.targetEncoding));
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
            os.flush();
            ((OutputStream)os).close();
            return rootPackageTmp;
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("could not create target XML installation file", e);
        }
    }

    protected void copyFiles(String _rootPackage) throws MojoExecutionException {
        try {
            for (String fileName : this.getCopyFiles()) {
                File srcFile = new File(this.getEFapsDir(), fileName);
                File dstFile = new File(this.targetDirectory, _rootPackage + fileName);
                FileUtils.copyFile((File)srcFile, (File)dstFile, (boolean)true);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("could not copy files", (Exception)e);
        }
    }

    protected String[] getCopyFiles() {
        DirectoryScanner ds = new DirectoryScanner();
        String[] includes = this.copyIncludes == null ? DEFAULT_COPYINCLUDES.toArray(new String[DEFAULT_COPYINCLUDES.size()]) : this.copyIncludes.toArray(new String[this.copyIncludes.size()]);
        String[] excludes = this.copyIncludes == null ? DEFAULT_COPYEXCLUDES.toArray(new String[DEFAULT_COPYEXCLUDES.size()]) : this.copyExcludes.toArray(new String[this.copyExcludes.size()]);
        ds.setIncludes(includes);
        ds.setExcludes(excludes);
        ds.setBasedir(this.getEFapsDir().toString());
        ds.setCaseSensitive(true);
        ds.scan();
        return ds.getIncludedFiles();
    }

    static {
        DEFAULT_COPYINCLUDES.add("**/*.css");
        DEFAULT_COPYINCLUDES.add("**/*.gif");
        DEFAULT_COPYINCLUDES.add("**/*.java");
        DEFAULT_COPYINCLUDES.add("**/*.js");
        DEFAULT_COPYINCLUDES.add("**/*.jrxml");
        DEFAULT_COPYINCLUDES.add("**/*.png");
        DEFAULT_COPYINCLUDES.add("**/*.properties");
        DEFAULT_COPYINCLUDES.add("**/*.wiki");
        DEFAULT_COPYINCLUDES.add("**/*.xml");
        DEFAULT_COPYINCLUDES.add("**/*.xsl");
        DEFAULT_COPYEXCLUDES = new HashSet<String>();
        DEFAULT_COPYEXCLUDES.add("**/versions.xml");
    }
}

