/*
 * Copyright 2003 - 2009 The eFaps Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Revision:        $Rev: 3430 $
 * Last Changed:    $Date: 2009-11-29 12:10:19 -0500 (Sun, 29 Nov 2009) $
 * Last Changed By: $Author: jan.moxter $
 */

package org.efaps.maven.plugin.install;

import org.apache.maven.plugin.MojoExecutionException;

import org.efaps.maven_java5.org.apache.maven.tools.plugin.Goal;
import org.efaps.update.version.Application;

/**
 * TODO description
 *
 * @author The eFaps Team
 * @version $Id: InstallMojo.java 3430 2009-11-29 17:10:19Z jan.moxter $
 */
@Goal(name = "install",
      requiresDependencyResolutionScope = "compile")
public final class InstallMojo
    extends AbstractEFapsInstallMojo
{
    /**
     * Executes the kernel install goal.
     *
     * @throws MojoExecutionException if a defined application could not be
     *                                found or the installation scripts could
     *                                not be executed
     */
    public void execute()
        throws MojoExecutionException
    {
        init();
        try {
            final Application appl = Application.getApplicationFromClassPath(getApplications(),
                                                                             getClasspathElements());
            // install application
            appl.install(getUserName(), getPassWord());
        } catch (final Exception e) {
            throw new MojoExecutionException("Could not execute Installation script", e);
        }
    }
}
