/*
 * Decompiled with CFR 0.152.
 */
package org.efaps.maven.plugin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.logging.Log;
import org.efaps.admin.runlevel.RunLevel;
import org.efaps.db.Context;
import org.efaps.init.StartupDatabaseConnection;
import org.efaps.init.StartupException;
import org.efaps.maven.logger.SLF4JOverMavenLog;
import org.efaps.maven_java5.org.apache.maven.tools.plugin.Parameter;
import org.efaps.util.EFapsException;

public abstract class EFapsAbstractMojo
implements Mojo {
    private Log log = null;
    @Parameter(required=true, expression="${org.efaps.db.factory}")
    private String factory;
    @Parameter(expression="${org.efaps.db.connection}", required=true)
    private String connection;
    @Parameter(required=true)
    private String userName;
    @Parameter(required=true)
    private String passWord;
    @Parameter(expression="${org.efaps.db.type}", required=true)
    private String type;
    @Parameter(expression="${org.efaps.transaction.timeout}", required=false)
    private String transactionTimeout;
    @Parameter(expression="${org.efaps.transaction.manager}", required=true, defaultValue="org.objectweb.jotm.Current")
    private String transactionManager;
    @Parameter(expression="${project.compileClasspathElements}", required=true, readonly=true)
    private List<String> classpathElements;

    protected EFapsAbstractMojo() {
    }

    protected void init() {
        try {
            Class.forName("org.efaps.maven.logger.SLF4JOverMavenLog");
            SLF4JOverMavenLog.LOGGER = this.getLog();
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            StartupDatabaseConnection.startup((String)this.type, (String)this.factory, this.convertToMap(this.connection), (String)this.transactionManager, this.transactionTimeout == null ? null : Integer.valueOf(Integer.parseInt(this.transactionTimeout)));
        }
        catch (StartupException e) {
            this.getLog().error((CharSequence)("Initialize Database Connection failed: " + e.toString()));
        }
    }

    protected void reloadCache() throws EFapsException {
        this.startTransaction();
        RunLevel.init((String)"shell");
        RunLevel.execute();
        this.abortTransaction();
    }

    protected void startTransaction() throws EFapsException {
        Context.begin((String)this.userName);
    }

    protected void abortTransaction() throws EFapsException {
        Context.rollback();
    }

    protected void commitTransaction() throws EFapsException {
        Context.commit();
    }

    protected Map<String, String> convertToMap(String _text) {
        HashMap<String, String> properties = new HashMap<String, String>();
        Pattern pattern = Pattern.compile("(([^\\\\,])|(\\\\,)|(\\\\))*");
        Matcher matcher = pattern.matcher(_text);
        while (matcher.find()) {
            String group = matcher.group().trim();
            if (group.length() <= 0) continue;
            int index = group.indexOf(61);
            String key = index > 0 ? group.substring(0, index).trim() : group.trim();
            String value = index > 0 ? group.substring(index + 1).trim() : "";
            properties.put(key, value);
        }
        return properties;
    }

    public void setLog(Log _log) {
        this.log = _log;
    }

    public Log getLog() {
        return this.log;
    }

    protected String getUserName() {
        return this.userName;
    }

    protected String getPassWord() {
        return this.passWord;
    }

    protected List<String> getClasspathElements() {
        return this.classpathElements;
    }
}

