/*
 * Copyright 2003 - 2009 The eFaps Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Revision:        $Rev: 3365 $
 * Last Changed:    $Date: 2009-11-26 16:36:21 -0500 (Thu, 26 Nov 2009) $
 * Last Changed By: $Author: tim.moxter $
 */

package org.efaps.maven.plugin.install;

import org.apache.maven.plugin.MojoExecutionException;
import org.efaps.maven_java5.org.apache.maven.tools.plugin.Goal;
import org.efaps.update.version.Application;

/**
 * Makes an update of an eFaps application for the last version of the
 * application.
 *
 * @author The eFaps Team
 * @version $Id: UpdateMojo.java 3365 2009-11-26 21:36:21Z tim.moxter $
 */
@Goal(name = "update",
      requiresDependencyResolutionScope = "compile")
public final class UpdateMojo
    extends AbstractEFapsInstallMojo
{
    /**
     * Executes the update goal.
     *
     * @throws MojoExecutionException if update failed
     */
    public void execute()
        throws MojoExecutionException
    {
        this.init();
        try  {
            final Application appl = Application.getApplicationFromClassPath(this.getApplications(),
                                                                             this.getClasspathElements());

            // update applications
            appl.updateLastVersion(this.getUserName(), this.getPassWord());
        } catch (final Exception e)  {
            throw new MojoExecutionException("Could not execute Installation script", e);
        }
    }
}
