/*
 * Decompiled with CFR 0.152.
 */
package org.efaps.maven_efaps_jetty;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.webapp.WebAppContext;
import org.efaps.init.StartupDatabaseConnection;
import org.efaps.init.StartupException;
import org.efaps.maven.logger.SLF4JOverMavenLog;
import org.efaps.maven_efaps_jetty.configuration.ServerDefinition;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;
import org.jfrog.maven.annomojo.annotations.MojoPhase;
import org.jfrog.maven.annomojo.annotations.MojoRequiresDependencyResolution;
import org.jfrog.maven.annomojo.annotations.MojoRequiresDirectInvocation;
import org.xml.sax.SAXException;

@MojoGoal(value="run")
@MojoRequiresDirectInvocation(value=true)
@MojoPhase(value="install")
@MojoRequiresDependencyResolution(value="compile")
public class JettyRunMojo
implements Mojo {
    @MojoParameter(defaultValue="8888")
    private int port;
    @MojoParameter(defaultValue="127.0.0.1")
    private String host;
    @MojoParameter(required=true)
    private String jaasConfigFile;
    @MojoParameter(required=true)
    private String configFile;
    @MojoParameter
    private String envFile;
    @MojoParameter(required=true, expression="${org.efaps.db.factory}")
    private String factory;
    @MojoParameter(expression="${org.efaps.db.connection}", required=true)
    private String connection;
    @MojoParameter(expression="${org.efaps.db.type}", required=true)
    private String type;
    @MojoParameter(expression="${org.efaps.configuration.properties}", required=false)
    private String configProps;
    @MojoParameter(expression="${org.efaps.transaction.manager}", defaultValue="org.objectweb.jotm.Current", required=true)
    private String transactionManager;
    private Log log = null;

    public void execute() throws MojoExecutionException {
        this.init();
        Server server = new Server();
        try {
            File file;
            if (this.envFile != null && (file = new File(this.envFile)).exists()) {
                EnvConfiguration envConfiguration = new EnvConfiguration();
                envConfiguration.setJettyEnvXml(file.toURI().toURL());
                WebAppContext webcontext = new WebAppContext();
                envConfiguration.configure(webcontext);
            }
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Could not read the Jetty env", (Exception)e);
        }
        catch (SAXException e) {
            throw new MojoExecutionException("Could not read the Jetty env", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not read the Jetty env", (Exception)e);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not read the Jetty env", e);
        }
        this.getLog().info((CharSequence)("Starting jetty Version " + server.getClass().getPackage().getImplementationVersion()));
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(this.port);
        connector.setHost(this.host);
        server.addConnector((Connector)connector);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        server.setHandler((Handler)contexts);
        System.setProperty("java.security.auth.login.config", this.jaasConfigFile);
        new WebAppContext();
        ServletContextHandler handler = new ServletContextHandler((HandlerContainer)contexts, "/eFaps", 1);
        ServerDefinition serverDef = ServerDefinition.read(this.configFile);
        serverDef.updateServer(handler);
        try {
            this.getLog().info((CharSequence)"Starting Server");
            server.start();
            this.getLog().info((CharSequence)"Server Started");
            server.join();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not Start Jetty Server", e);
        }
    }

    protected void init() {
        try {
            Class.forName("org.efaps.maven.logger.SLF4JOverMavenLog");
            SLF4JOverMavenLog.LOGGER = this.getLog();
        }
        catch (ClassNotFoundException e) {
            this.getLog().error((CharSequence)"could not initialize SLF4J over maven logger");
        }
        try {
            StartupDatabaseConnection.startup((String)this.type, (String)this.factory, (String)this.connection, (String)this.transactionManager, this.convertToMap(this.configProps));
        }
        catch (StartupException e) {
            this.getLog().error((CharSequence)("Initialize Database Connection failed: " + e.toString()));
        }
    }

    public void setLog(Log _log) {
        this.log = _log;
    }

    public Log getLog() {
        return this.log;
    }

    protected Map<String, String> convertToMap(String _text) {
        HashMap<String, String> properties = new HashMap<String, String>();
        Pattern pattern = Pattern.compile("(([^\\\\,])|(\\\\,)|(\\\\))*");
        Matcher matcher = pattern.matcher(_text);
        while (matcher.find()) {
            String group = matcher.group().trim();
            if (group.length() <= 0) continue;
            int index = group.indexOf(61);
            String key = index > 0 ? group.substring(0, index).trim() : group.trim();
            String value = index > 0 ? group.substring(index + 1).trim() : "";
            properties.put(key, value);
        }
        return properties;
    }
}

