/*
 * Copyright 2003 - 2012 The eFaps Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Revision:        $Rev: 7510 $
 * Last Changed:    $Date: 2012-05-11 13:50:29 -0500 (Fri, 11 May 2012) $
 * Last Changed By: $Author: jan@moxter.net $
 */

package org.efaps.maven_efaps_jetty.configuration;

import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

/**
 * @author The eFaps Team
 * @version $Id: ServletDefinition.java 7510 2012-05-11 18:50:29Z jan@moxter.net $
 * @todo description
 */
public class ServletDefinition
    extends AbstractDefinition
{
    /**
     * Initialize order of the servlet.
     */
    private Integer initOrder;

    /**
     * Display name of the servlet.
     */
    private String displayName;

    /**
     *
     * @param _handler servlet context handler
     */
    public void updateServer(final ServletContextHandler _handler)
    {
        final ServletHolder servlet = new ServletHolder();
        servlet.setName(getName());
        servlet.setDisplayName(this.displayName);
        servlet.setClassName(getClassName());
        servlet.setInitParameters(getIniParams());
        if (this.initOrder != null)  {
            servlet.setInitOrder(this.initOrder);
        }
        _handler.addServlet(servlet, getPathSpec());
    }

    /**
     * Setter method for instance variable {@link #initOrder}.
     *
     * @param _initOrder    new initt order to set
     * @see #initOrder
     */
    public void setInitOrder(final int _initOrder)
    {
        this.initOrder = _initOrder;
    }

    /**
     * Setter method for instance variable {@link #displayName}.
     *
     * @param _displayName  new display name to set
     * @see #displayName
     */
    public void setDisplayName(final String _displayName)
    {
        this.displayName = _displayName;
    }
}
