/*
 * Copyright 2003 - 2012 The eFaps Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Revision:        $Rev: 7510 $
 * Last Changed:    $Date: 2012-05-11 13:50:29 -0500 (Fri, 11 May 2012) $
 * Last Changed By: $Author: jan@moxter.net $
 */

package org.efaps.maven_efaps_jetty.configuration;

import java.util.EnumSet;

import javax.servlet.DispatcherType;

import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;

/**
 * @author The eFaps Team
 * @version $Id: FilterDefinition.java 7510 2012-05-11 18:50:29Z jan@moxter.net $
 * @todo description
 */
public class FilterDefinition
    extends AbstractDefinition
{

    /**
     *
     * @param _handler servlet context handler
     */
    public void updateServer(final ServletContextHandler _handler)
    {
        final FilterHolder filter = new FilterHolder();
        filter.setName(getName());
        filter.setClassName(getClassName());
        filter.setInitParameters(getIniParams());
        _handler.addFilter(filter, getPathSpec(), EnumSet.of(DispatcherType.REQUEST));
    }
}
