/*
 * Decompiled with CFR 0.152.
 */
package org.easywatermark.enums;

import org.easywatermark.exception.FileTypeUnsupportException;

public enum FileTypeEnums {
    IMAGE,
    PDF,
    OFFICE;

    private static final byte[] PNG_BYTE;
    private static final byte[] JPG_JPEG_BYTE;
    private static final byte[] WEBP_BYTE;
    private static final byte[] BMP_BYTE;
    private static final byte[] PDF_BYTE;
    private static final byte[] OFFICE_BYTE;

    public static FileTypeEnums parseFileType(byte[] date) {
        if (FileTypeEnums.isOffice(date)) {
            return OFFICE;
        }
        if (FileTypeEnums.isPdf(date)) {
            return PDF;
        }
        if (FileTypeEnums.isImage(date)) {
            return IMAGE;
        }
        throw new FileTypeUnsupportException("File type is not support.");
    }

    private static boolean isOffice(byte[] data) {
        return FileTypeEnums.isType(data, OFFICE_BYTE);
    }

    private static boolean isPdf(byte[] data) {
        return FileTypeEnums.isType(data, PDF_BYTE);
    }

    public static boolean isImage(byte[] data) {
        return FileTypeEnums.isType(data, PNG_BYTE) || FileTypeEnums.isType(data, JPG_JPEG_BYTE) || FileTypeEnums.isType(data, WEBP_BYTE) || FileTypeEnums.isType(data, BMP_BYTE);
    }

    private static boolean isType(byte[] data, byte[] type) {
        if (data.length < type.length) {
            return false;
        }
        for (int i = 0; i < type.length; ++i) {
            if (data[i] == type[i]) continue;
            return false;
        }
        return true;
    }

    static {
        PNG_BYTE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        JPG_JPEG_BYTE = new byte[]{-1, -40};
        WEBP_BYTE = new byte[]{82, 73, 70, 70};
        BMP_BYTE = new byte[]{66, 77};
        PDF_BYTE = new byte[]{37, 80, 68, 70};
        OFFICE_BYTE = new byte[]{80, 75, 3, 4};
    }
}

