/*
 * Decompiled with CFR 0.152.
 */
package org.easywatermark.core.handler;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.docx4j.dml.CTTransform2D;
import org.docx4j.dml.wordprocessingDrawing.Anchor;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.model.structure.SectionWrapper;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.vml.CTShape;
import org.docx4j.vml.CTTextPath;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.Hdr;
import org.docx4j.wml.HdrFtrRef;
import org.docx4j.wml.HeaderReference;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.SectPr;
import org.easywatermark.core.AbstractWatermarkHandler;
import org.easywatermark.core.EasyWatermarkCustomDraw;
import org.easywatermark.core.config.FontConfig;
import org.easywatermark.core.config.WatermarkConfig;
import org.easywatermark.entity.PageInfo;
import org.easywatermark.entity.Point;
import org.easywatermark.entity.WatermarkBox;
import org.easywatermark.enums.CenterLocationTypeEnum;
import org.easywatermark.enums.DiagonalDirectionTypeEnum;
import org.easywatermark.enums.EasyWatermarkTypeEnum;
import org.easywatermark.enums.WatermarkTypeEnum;
import org.easywatermark.exception.DocxWatermarkHandlerException;
import org.easywatermark.exception.LoadFileException;
import org.easywatermark.exception.LoadFontException;
import org.easywatermark.utils.DocxUtils;
import org.easywatermark.utils.EasyWatermarkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocxWatermarkHandler
extends AbstractWatermarkHandler<Font, Object> {
    private static final Logger log = LoggerFactory.getLogger(DocxWatermarkHandler.class);
    private final List<HeaderPart> watermarkHeaderPartList = new ArrayList<HeaderPart>();
    private final List<P> watermarkPList = new ArrayList<P>();
    private final Map<Integer, BinaryPartAbstractImage> imageWatermarkCacheMap = new HashMap<Integer, BinaryPartAbstractImage>();
    private StringBuilder watermarkShapeStyle = new StringBuilder("position:absolute;");
    private WordprocessingMLPackage file;
    private FontMetrics fontMetrics;
    private List<SectionWrapper> sectionWrapperList;
    private BufferedImage watermarkBufferedImage;

    public DocxWatermarkHandler(byte[] data, FontConfig fontConfig, WatermarkConfig watermarkConfig) {
        super(data, fontConfig, watermarkConfig);
    }

    @Override
    protected void initGraphics() {
    }

    @Override
    protected void initFont() {
        try {
            Font font = this.fontConfig.getFontFile() != null ? Font.createFont(0, this.fontConfig.getFontFile()) : new Font(this.fontConfig.getFontName(), this.fontConfig.getFontStyle(), this.fontConfig.getFontSize());
            this.font = font.deriveFont(this.fontConfig.getFontStyle(), this.fontConfig.getFontSize());
            BufferedImage image = new BufferedImage(1, 1, 2);
            Graphics graphics = image.getGraphics();
            this.fontMetrics = graphics.getFontMetrics((Font)this.font);
        }
        catch (FontFormatException | IOException e) {
            log.error("Load font error. Font file:{}", (Object)this.fontConfig.getFontFile(), (Object)e);
            throw new LoadFontException("Load font error.", e);
        }
    }

    @Override
    protected void initEnvironment() {
        this.sectionWrapperList = this.file.getDocumentModel().getSections();
        for (int i = 0; i < this.sectionWrapperList.size(); ++i) {
            P p = new P();
            this.watermarkPList.add(p);
            Hdr hdr = new Hdr();
            hdr.getContent().add(p);
            Relationship watermarkRelationship = this.createEasyWatermarkRelationship(this.file, hdr, i);
            SectionWrapper sectionWrapper = this.sectionWrapperList.get(i);
            SectPr sectPr = sectionWrapper.getSectPr();
            if (sectPr == null) {
                sectPr = new SectPr();
                this.file.getMainDocumentPart().addObject((Object)sectPr);
                sectionWrapper.setSectPr(sectPr);
            }
            List egHdrFtrReferences = sectPr.getEGHdrFtrReferences();
            HeaderReference headerReference = new HeaderReference();
            headerReference.setId(watermarkRelationship.getId());
            headerReference.setType(HdrFtrRef.DEFAULT);
            egHdrFtrReferences.add(headerReference);
        }
        if (this.getWatermarkType() == WatermarkTypeEnum.IMAGE) {
            try {
                this.watermarkBufferedImage = ImageIO.read(new ByteArrayInputStream(this.watermarkImage));
            }
            catch (IOException e) {
                log.warn("Load image error.", (Throwable)e);
                throw new LoadFileException("Load image error.", e);
            }
        }
    }

    @Override
    protected float getFileWidth(int page) {
        this.checkPageInfoList();
        return this.sectionWrapperList.get(page).getPageDimensions().getPgSz().getW().floatValue() / 20.0f;
    }

    @Override
    protected float getFileHeight(int page) {
        this.checkPageInfoList();
        return this.sectionWrapperList.get(page).getPageDimensions().getPgSz().getH().floatValue() / 20.0f;
    }

    @Override
    protected float getWatermarkImageWidth() {
        return (float)this.watermarkBufferedImage.getWidth() / 1.3333334f;
    }

    @Override
    protected float getWatermarkImageHeight() {
        return (float)this.watermarkBufferedImage.getHeight() / 1.3333334f;
    }

    @Override
    protected byte[] export(EasyWatermarkTypeEnum watermarkType) {
        ByteArrayOutputStream res = new ByteArrayOutputStream();
        try {
            this.file.save((OutputStream)res);
        }
        catch (Docx4JException e) {
            log.error("Export data error.", (Throwable)e);
            throw new DocxWatermarkHandlerException("Export data error.", e);
        }
        return res.toByteArray();
    }

    @Override
    public void customDraw(EasyWatermarkCustomDraw easyWatermarkCustomDraw) {
        for (int pageNumber = 0; pageNumber < this.sectionWrapperList.size(); ++pageNumber) {
            PageInfo pageInfo = new PageInfo(this.getFileWidth(pageNumber), this.getFileHeight(pageNumber), pageNumber);
            easyWatermarkCustomDraw.draw(pageInfo, this, this);
        }
    }

    @Override
    public void drawCenterWatermark() {
        WatermarkTypeEnum watermarkType = this.getWatermarkType();
        switch (watermarkType) {
            case SINGLE_TEXT: {
                for (int i = 0; i < this.sectionWrapperList.size(); ++i) {
                    Point point = this.calcCenterWatermarkPoint(this.watermarkText, i);
                    this.drawString(point.getX(), point.getY(), this.watermarkText, i);
                }
                break;
            }
            case MULTI_TEXT: {
                for (int i = 0; i < this.sectionWrapperList.size(); ++i) {
                    WatermarkBox watermarkBox = this.getWatermarkBox(watermarkType, i);
                    int watermarkListHeight = (int)watermarkBox.getHeight();
                    float startY = (this.getFileHeight(i) - (float)watermarkListHeight) / 2.0f;
                    if (this.watermarkConfig.getCenterLocationType() == CenterLocationTypeEnum.TOP_CENTER) {
                        startY = 0.0f;
                    } else if (this.watermarkConfig.getCenterLocationType() == CenterLocationTypeEnum.BOTTOM_CENTER) {
                        startY = this.getFileHeight(i) - (float)watermarkListHeight;
                    }
                    for (int j = 0; j < this.watermarkTextList.size(); ++j) {
                        String curWatermarkText = (String)this.watermarkTextList.get(j);
                        Point point = this.calcCenterWatermarkPoint(curWatermarkText, i);
                        this.drawString(point.getX(), startY + (float)j * this.getStringHeight(), curWatermarkText, i);
                    }
                }
                break;
            }
            case IMAGE: {
                for (int i = 0; i < this.sectionWrapperList.size(); ++i) {
                    Point point = this.calcCenterWatermarkPoint(this.getWatermarkImageWidth(), this.getWatermarkImageHeight(), i);
                    this.drawImage(point.getX(), point.getY(), this.watermarkImage, i);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not support watermark type.");
            }
        }
    }

    @Override
    public void drawOverspreadWatermark() {
        for (int pageNumber = 0; pageNumber < this.sectionWrapperList.size(); ++pageNumber) {
            this.drawOverspreadWatermark(pageNumber);
        }
    }

    @Override
    public void drawDiagonalWatermark() {
        block9: for (int pageNumber = 0; pageNumber < this.sectionWrapperList.size(); ++pageNumber) {
            double degrees;
            DiagonalDirectionTypeEnum diagonalDirectionType = this.watermarkConfig.getDiagonalDirectionType();
            switch (diagonalDirectionType) {
                case TOP_TO_BOTTOM: {
                    degrees = EasyWatermarkUtils.calcDegrees(this.getFileWidth(pageNumber), this.getFileHeight(pageNumber));
                    break;
                }
                case BOTTOM_TO_TOP: {
                    degrees = EasyWatermarkUtils.calcDegrees(this.getFileWidth(pageNumber), -this.getFileHeight(pageNumber));
                    break;
                }
                default: {
                    throw new DocxWatermarkHandlerException("Unsupported diagonal watermark type.");
                }
            }
            WatermarkTypeEnum watermarkType = this.getWatermarkType();
            switch (watermarkType) {
                case SINGLE_TEXT: {
                    Point point = this.calcCenterWatermarkPoint(this.watermarkText, pageNumber);
                    this.rotation(degrees);
                    this.drawString(point.getX(), point.getY(), this.watermarkText, pageNumber);
                    continue block9;
                }
                case MULTI_TEXT: {
                    WatermarkBox watermarkBox = this.getWatermarkBox(watermarkType, pageNumber);
                    Point point = this.calcCenterWatermarkPoint(watermarkBox.getWidth(), watermarkBox.getHeight(), pageNumber);
                    this.rotation(degrees);
                    this.drawCenterMultiLineString(point.getX(), point.getY(), this.watermarkTextList, pageNumber);
                    continue block9;
                }
                case IMAGE: {
                    Point point = this.calcCenterWatermarkPoint(this.watermarkBufferedImage.getWidth(), this.watermarkBufferedImage.getHeight(), pageNumber);
                    this.drawImage0(point.getX(), point.getY(), this.watermarkImage, pageNumber, degrees);
                }
            }
        }
    }

    @Override
    public void loadFile(byte[] data) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
        try {
            this.file = WordprocessingMLPackage.load((InputStream)byteArrayInputStream);
        }
        catch (Docx4JException e) {
            log.error("Load data error.", (Throwable)e);
            throw new DocxWatermarkHandlerException("Load data error.", e);
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public float getStringWidth(String text) {
        if (text.contains("\n")) {
            String[] split = text.split("\n");
            float res = 0.0f;
            for (String s : split) {
                res = Math.max(res, (float)this.fontMetrics.stringWidth(s));
            }
            return res;
        }
        return this.fontMetrics.stringWidth(text);
    }

    @Override
    public float getStringHeight() {
        return this.fontMetrics.getHeight();
    }

    @Override
    public void drawString(float x, float y, String text, int pageNumber) {
        this.drawMultiLineString(x, y, Collections.singletonList(text), pageNumber);
    }

    @Override
    public void drawMultiLineString(float x, float y, List<String> text, int pageNumber) {
        String watermarkText = String.join((CharSequence)"\n", text);
        CTTextPath normalTextPath = DocxUtils.createNormalTextPath(watermarkText, ((Font)this.font).getFontName());
        this.drawMultiLineString(x, y, text, pageNumber, normalTextPath);
    }

    private void drawCenterMultiLineString(float x, float y, List<String> text, int pageNumber) {
        String watermarkText = String.join((CharSequence)"\n", text);
        CTTextPath centerTextPath = DocxUtils.createCenterTextPath(watermarkText, ((Font)this.font).getFontName());
        this.drawMultiLineString(x, y, text, pageNumber, centerTextPath);
    }

    private void drawMultiLineString(float x, float y, List<String> text, int pageNumber, CTTextPath textPath) {
        String watermarkText = String.join((CharSequence)"\n", text);
        SectionWrapper sectionWrapper = this.sectionWrapperList.get(pageNumber);
        SectPr.PgMar pgMar = sectionWrapper.getSectPr().getPgMar();
        this.watermarkShapeStyle.append(this.setLocation(pgMar.getHeader().floatValue(), pgMar.getLeft().floatValue(), x, y));
        this.watermarkShapeStyle.append(String.format("width:%spt;height:%spt;", Float.valueOf(this.getStringWidth(watermarkText)), Float.valueOf(this.getStringHeight() * (float)text.size())));
        CTShape normalShape = DocxUtils.createNormalShape(this.watermarkConfig.getColor());
        normalShape.setStyle(this.watermarkShapeStyle.toString());
        this.initWatermarkShapeStyle();
        this.addTextWatermark(textPath, normalShape, pageNumber);
    }

    @Override
    public void drawImage(float x, float y, byte[] data, int pageNumber) {
        this.drawImage0(x, y, data, pageNumber, null);
    }

    private void drawImage0(float x, float y, byte[] data, int pageNumber, Double degrees) {
        SectPr.PgMar pgMar = this.sectionWrapperList.get(pageNumber).getSectPr().getPgMar();
        float realX = x - pgMar.getLeft().floatValue() / 20.0f;
        float realY = y - pgMar.getTop().floatValue() / 20.0f;
        try {
            if (log.isDebugEnabled()) {
                log.debug("Draw image, page number: {}, x: {}pt(real: {}pt), y: {}pt(real: {}pt).(need delete the margin)", new Object[]{pageNumber, Float.valueOf(x), Float.valueOf(realX), Float.valueOf(y), Float.valueOf(realY)});
            }
            HeaderPart headerPart = this.watermarkHeaderPartList.get(pageNumber);
            if (!this.imageWatermarkCacheMap.containsKey(pageNumber)) {
                BinaryPartAbstractImage tmpImage = BinaryPartAbstractImage.createImagePart((OpcPackage)this.file, (Part)headerPart, (byte[])data);
                this.imageWatermarkCacheMap.put(pageNumber, tmpImage);
            }
            BinaryPartAbstractImage imagePart = this.imageWatermarkCacheMap.get(pageNumber);
            Inline imageInline = imagePart.createImageInline("easy-watermark framework", "easy-watermark framework", 111L, 111, false);
            R r = new R();
            Drawing drawing = new Drawing();
            r.getContent().add(drawing);
            Anchor anchor = DocxUtils.createAnchorByInline(imageInline, realX, realY);
            drawing.getAnchorOrInline().add(anchor);
            this.watermarkPList.get(pageNumber).getContent().add(r);
            if (degrees != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Draw image, page number: {}, degrees: {}", (Object)pageNumber, (Object)degrees);
                }
                this.rotation(degrees, anchor);
            }
        }
        catch (Exception e) {
            log.error("Draw image error.", (Throwable)e);
            throw new DocxWatermarkHandlerException("Draw image error.", e);
        }
    }

    @Override
    public void rotate(float angle, float x, float y, int pageNumber) {
    }

    private void rotation(double degrees) {
        this.watermarkShapeStyle.append(String.format("rotation:%f;", degrees));
    }

    private void rotation(double degrees, Anchor anchor) {
        CTTransform2D xfrm = anchor.getGraphic().getGraphicData().getPic().getSpPr().getXfrm();
        xfrm.setRot(Integer.valueOf((int)degrees * 60000));
    }

    private Relationship createEasyWatermarkRelationship(WordprocessingMLPackage wordprocessingMLPackage, Hdr hdr, Integer pageNumber) {
        try {
            HeaderPart headerPart = new HeaderPart(new PartName("/word/easy-watermark-header" + pageNumber + ".xml"));
            headerPart.setJaxbElement((Object)hdr);
            this.watermarkHeaderPartList.add(pageNumber, headerPart);
            return wordprocessingMLPackage.getMainDocumentPart().addTargetPart((Part)headerPart);
        }
        catch (Exception e) {
            log.error("Add easy watermark header error.", (Throwable)e);
            throw new DocxWatermarkHandlerException("Add easy watermark header error.", e);
        }
    }

    private void addTextWatermark(CTTextPath textPath, CTShape shape, Integer pageNumber) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Draw text, page number: {}, text: {}, shape style:'{}'", new Object[]{pageNumber, textPath.getString(), shape.getStyle()});
            }
            P p = this.watermarkPList.get(pageNumber);
            R watermarkHeader = DocxUtils.createR(textPath, shape, this.watermarkConfig.getAlpha());
            p.getContent().add(watermarkHeader);
        }
        catch (Exception e) {
            log.error("Add watermark error.", (Throwable)e);
            throw new DocxWatermarkHandlerException("Add watermark error.", e);
        }
    }

    private void checkPageInfoList() {
        if (this.sectionWrapperList == null || this.sectionWrapperList.isEmpty()) {
            throw new DocxWatermarkHandlerException("Page info list is empty.");
        }
    }

    private void initWatermarkShapeStyle() {
        this.watermarkShapeStyle = new StringBuilder("position:absolute;");
    }

    private String setLocation(float headerTopMargin, float headerLeftMargin, float x, float y) {
        float leftMargin = -headerLeftMargin / 20.0f;
        float topMargin = -headerTopMargin / 20.0f;
        return String.format("margin-left:%spt;margin-top:%spt;", Float.valueOf(leftMargin += x), Float.valueOf(topMargin += y));
    }
}

