/*
 * Decompiled with CFR 0.152.
 */
package dyvilx.tools.gensrc.parser;

import dyvil.source.position.SourcePosition;
import dyvilx.tools.compiler.ast.expression.IValue;
import dyvilx.tools.compiler.ast.statement.StatementList;
import dyvilx.tools.compiler.parser.expression.ExpressionParser;
import dyvilx.tools.gensrc.ast.directive.IfDirective;
import dyvilx.tools.gensrc.lexer.GenSrcLexer;
import dyvilx.tools.gensrc.parser.BlockParser;
import dyvilx.tools.parsing.IParserManager;
import dyvilx.tools.parsing.Parser;
import dyvilx.tools.parsing.token.IToken;

public class IfDirectiveParser
extends Parser {
    public static final int IF = 0;
    public static final int OPEN_PAREN = 1;
    public static final int CLOSE_PAREN = 2;
    public static final int THEN_BODY = 3;
    public static final int THEN_BODY_END = 4;
    public static final int ELSE = 5;
    public static final int ELSE_BODY = 6;
    public static final int ELSE_BODY_END = 7;
    private final StatementList list;
    private IfDirective directive;

    public IfDirectiveParser(StatementList list) {
        this.list = list;
    }

    public void parse(IParserManager pm, IToken token) {
        int type = token.type();
        switch (this.mode) {
            case 0: {
                assert (type == 1376258);
                this.directive = new IfDirective(token.raw());
                this.mode = 1;
                return;
            }
            case 1: {
                if (type != 65544) {
                    pm.report((SourcePosition)token, "if.open_paren");
                    this.list.add((IValue)this.directive);
                    pm.popParser(true);
                    return;
                }
                pm.pushParser((Parser)new ExpressionParser(arg_0 -> ((IfDirective)this.directive).setCondition(arg_0)));
                this.mode = 2;
                return;
            }
            case 2: {
                if (type != 0x110008) {
                    pm.report((SourcePosition)token, "if.close_paren");
                    return;
                }
                this.mode = 3;
                return;
            }
            case 3: {
                if (type != 262152) {
                    pm.report((SourcePosition)token, "if.open_brace");
                    this.list.add((IValue)this.directive);
                    pm.popParser(true);
                    return;
                }
                StatementList thenBlock = new StatementList();
                pm.pushParser((Parser)new BlockParser(thenBlock));
                this.directive.setThen((IValue)thenBlock);
                this.mode = 4;
                return;
            }
            case 4: {
                if (type != 1310728) {
                    pm.report((SourcePosition)token, "if.close_brace");
                    this.list.add((IValue)this.directive);
                    pm.popParser();
                    return;
                }
                this.mode = 5;
                return;
            }
            case 5: {
                if (type == 256 && IfDirectiveParser.isBlank(token.stringValue()) && IfDirectiveParser.isHashElse(token.next())) {
                    pm.skip(2);
                    this.mode = 6;
                    return;
                }
                if (IfDirectiveParser.isHashElse(token)) {
                    pm.skip();
                    this.mode = 6;
                    return;
                }
                this.list.add((IValue)this.directive);
                pm.popParser(true);
                return;
            }
            case 6: {
                if (type != 262152) {
                    pm.report((SourcePosition)token, "if.else.open_brace");
                    this.list.add((IValue)this.directive);
                    pm.popParser(true);
                    return;
                }
                StatementList elseBlock = new StatementList();
                pm.pushParser((Parser)new BlockParser(elseBlock));
                this.directive.setElse((IValue)elseBlock);
                this.mode = 7;
                return;
            }
            case 7: {
                if (type != 1310728) {
                    pm.report((SourcePosition)token, "if.else.close_brace");
                }
                this.list.add((IValue)this.directive);
                pm.popParser();
            }
        }
    }

    private static boolean isHashElse(IToken token) {
        return token.type() == 393220 && token.next().type() == 655362;
    }

    private static boolean isBlank(String value) {
        int length = value.length();
        return GenSrcLexer.skipWhitespace(value, 0, length) == length;
    }
}

