/*
 * Decompiled with CFR 0.152.
 */
package dyvilx.tools.gensrc.lexer;

import dyvil.lang.Name;
import dyvilx.tools.compiler.parser.DyvilSymbols;
import dyvilx.tools.gensrc.lexer.GenSrcSymbols;
import dyvilx.tools.parsing.TokenList;
import dyvilx.tools.parsing.lexer.BaseSymbols;
import dyvilx.tools.parsing.lexer.CharacterTypes;
import dyvilx.tools.parsing.lexer.DyvilLexer;
import dyvilx.tools.parsing.lexer.Lexer;
import dyvilx.tools.parsing.lexer.Symbols;
import dyvilx.tools.parsing.marker.MarkerList;
import dyvilx.tools.parsing.token.IToken;
import dyvilx.tools.parsing.token.IdentifierToken;
import dyvilx.tools.parsing.token.StringToken;
import dyvilx.tools.parsing.token.SymbolToken;

public class GenSrcLexer
extends Lexer {
    protected int braceLevel;
    protected final int blockLevel;

    public GenSrcLexer(MarkerList markers) {
        this(markers, 0);
    }

    public GenSrcLexer(MarkerList markers, int blockLevel) {
        super(markers, (Symbols)GenSrcSymbols.INSTANCE);
        this.blockLevel = blockLevel;
    }

    public TokenList tokenize(String code, int cursor, int line, int column) {
        this.init(code, cursor, line, column);
        block4: while (true) {
            int currentChar = this.codePoint();
            switch (currentChar) {
                case 0: {
                    break block4;
                }
                case 125: {
                    if (this.braceLevel <= 0) break block4;
                }
                default: {
                    this.parseCharacter(currentChar);
                    continue block4;
                }
            }
            break;
        }
        this.finish();
        return this.tokens;
    }

    protected void parseCharacter(int i) {
        switch (i) {
            case 35: {
                this.parseDirective();
                break;
            }
            default: {
                this.parsePlain();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parsePlain() {
        for (int i = 0; i < this.blockLevel && this.codePoint() == 9; ++i) {
            this.advance();
        }
        int startIndex = this.cursor;
        int startColumn = this.column;
        int startLine = this.line;
        block8: while (true) {
            int current = this.codePoint();
            switch (current) {
                case 0: {
                    break block8;
                }
                case 35: {
                    break block8;
                }
                case 123: {
                    ++this.braceLevel;
                    break;
                }
                case 125: {
                    if (this.braceLevel == 0) break block8;
                    --this.braceLevel;
                    break;
                }
                case 10: {
                    this.newLine();
                    break block8;
                }
            }
            this.advance(current);
        }
        if (startIndex == this.cursor) {
            return;
        }
        this.tokens.append((IToken)new StringToken(this.code.substring(startIndex, this.cursor), 256, startLine, this.line, startColumn, this.column));
    }

    private void parseDirective() {
        this.tokens.append((IToken)new SymbolToken((Symbols)BaseSymbols.INSTANCE, 393220, this.line, this.column));
        this.advance();
        this.parseIdentifier();
        this.parseArguments();
        this.parseBlock();
    }

    private void parseArguments() {
        if (!this.skipTo(40)) {
            return;
        }
        this.tokens.append((IToken)new SymbolToken((Symbols)BaseSymbols.INSTANCE, 65544, this.line, this.column));
        this.advance();
        this.parseDyvilArguments();
        int current = this.codePoint();
        if (current == 0) {
            return;
        }
        assert (current == 41);
        this.tokens.append((IToken)new SymbolToken((Symbols)BaseSymbols.INSTANCE, 0x110008, this.line, this.column));
        this.advance();
        this.skipNewLine();
    }

    private void parseBlock() {
        if (!this.skipTo(123)) {
            return;
        }
        this.tokens.append((IToken)new SymbolToken((Symbols)BaseSymbols.INSTANCE, 262152, this.line, this.column));
        this.advance();
        this.skipNewLine();
        this.parseNestedBlock();
        int current = this.codePoint();
        if (current == 0) {
            return;
        }
        assert (current == 125);
        this.tokens.append((IToken)new SymbolToken((Symbols)BaseSymbols.INSTANCE, 1310728, this.line, this.column));
        this.advance();
        this.skipNewLine();
    }

    private boolean skipTo(int c) {
        int current = this.codePoint();
        int indexOfNonWhite = GenSrcLexer.skipWhitespace(this.code, this.cursor, this.length);
        if (indexOfNonWhite >= this.length) {
            return false;
        }
        if (this.code.codePointAt(indexOfNonWhite) != c) {
            return false;
        }
        this.skipWhitespace(current);
        return true;
    }

    private void skipNewLine() {
        if (this.codePoint() == 10) {
            this.newLine();
        }
    }

    private void skipWhitespace(int current) {
        while (current != 0 && Character.isWhitespace(current)) {
            if (current == 10) {
                this.newLine();
            } else {
                this.advance(current);
            }
            current = this.codePoint();
        }
    }

    private void parseIdentifier() {
        int startColumn = this.column;
        int startIndex = this.cursor;
        int current = this.codePoint();
        while (current != 0 && CharacterTypes.isIdentifierPart((int)current)) {
            this.advance(current);
            current = this.codePoint();
        }
        if (startIndex == this.cursor) {
            return;
        }
        String identifier = this.code.substring(startIndex, this.cursor);
        int keyWord = this.symbols.getKeywordType(identifier);
        if (keyWord != 0) {
            this.tokens.append((IToken)new SymbolToken(this.symbols, keyWord, this.line, startColumn));
            return;
        }
        this.tokens.append((IToken)new IdentifierToken(Name.fromQualified((String)identifier), 65537, this.line, startColumn, this.column));
    }

    private void parseDyvilArguments() {
        DyvilLexer sublexer = new DyvilLexer(this.markers, (Symbols)DyvilSymbols.INSTANCE);
        sublexer.setInterpolationEnd();
        this.useSubLexer((Lexer)sublexer);
    }

    private void parseNestedBlock() {
        GenSrcLexer sublexer = new GenSrcLexer(this.markers, this.blockLevel + 1);
        this.useSubLexer(sublexer);
    }

    public static int skipWhitespace(String line, int start, int end) {
        while (start < end) {
            if (!Character.isWhitespace(line.charAt(start))) {
                return start;
            }
            ++start;
        }
        return end;
    }
}

