/*
 * Decompiled with CFR 0.152.
 */
package dyvilx.tools.gensrc.ast.directive;

import dyvil.annotation.internal.NonNull;
import dyvil.lang.Name;
import dyvil.source.position.SourcePosition;
import dyvilx.tools.compiler.ast.context.IContext;
import dyvilx.tools.compiler.ast.expression.IValue;
import dyvilx.tools.compiler.ast.expression.StringInterpolationExpr;
import dyvilx.tools.compiler.ast.expression.access.FieldAccess;
import dyvilx.tools.compiler.ast.expression.constant.StringValue;
import dyvilx.tools.compiler.ast.field.IDataMember;
import dyvilx.tools.compiler.ast.header.IClassCompilableList;
import dyvilx.tools.compiler.ast.header.ICompilableList;
import dyvilx.tools.compiler.ast.type.IType;
import dyvilx.tools.compiler.backend.exception.BytecodeException;
import dyvilx.tools.compiler.backend.method.MethodWriter;
import dyvilx.tools.gensrc.ast.GenSrcValue;
import dyvilx.tools.gensrc.ast.directive.WriteCall;
import dyvilx.tools.parsing.lexer.CharacterTypes;
import dyvilx.tools.parsing.marker.MarkerList;

public class ProcessedText
implements GenSrcValue {
    protected String text;
    protected SourcePosition position;

    public ProcessedText(String value) {
        this.text = value;
    }

    public ProcessedText(SourcePosition position, String text) {
        this.position = position;
        this.text = text;
    }

    public int valueTag() {
        return 512;
    }

    public SourcePosition getPosition() {
        return this.position;
    }

    public void setPosition(SourcePosition position) {
        this.position = position;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public boolean isResolved() {
        return true;
    }

    public void resolveTypes(MarkerList markers, IContext context) {
    }

    public IValue resolve(MarkerList markers, IContext context) {
        int startLine = this.position.startLine();
        int startColumn = this.position.startColumn();
        StringInterpolationExpr parts = new StringInterpolationExpr();
        String text = this.text;
        int length = text.length();
        int prev = 0;
        int startIndex = 0;
        while (startIndex < length) {
            int c = text.codePointAt(startIndex);
            if (!Character.isJavaIdentifierStart(c)) {
                startIndex += Character.charCount(c);
                continue;
            }
            int endIndex = ProcessedText.identifierEnd(text, startIndex + 1, length);
            String key = text.substring(startIndex, endIndex);
            IDataMember field = context.resolveField(Name.fromRaw((String)key));
            if (field != null && (field.isLocal() || field.hasModifier(1))) {
                parts.append((IValue)new StringValue(text.substring(prev, startIndex)));
                SourcePosition position = SourcePosition.apply((int)startLine, (int)(startColumn + startIndex), (int)(startColumn + endIndex));
                parts.append((IValue)new FieldAccess(position, null, field));
                prev = endIndex;
                startIndex = endIndex;
                continue;
            }
            startIndex += Character.charCount(c);
        }
        if (prev != length) {
            parts.append((IValue)new StringValue(text.substring(prev, length)));
        }
        return new WriteCall(parts.resolve(markers, context));
    }

    private static int identifierEnd(String text, int start, int end) {
        while (start < end) {
            int cp = text.codePointAt(start);
            if (!CharacterTypes.isIdentifierPart((int)cp)) {
                return start;
            }
            start += Character.charCount(cp);
        }
        return end;
    }

    public void checkTypes(MarkerList markers, IContext context) {
    }

    public void check(MarkerList markers, IContext context) {
    }

    public IValue foldConstants() {
        return this;
    }

    public IValue cleanup(ICompilableList compilableList, IClassCompilableList classCompilableList) {
        return this;
    }

    public void writeExpression(MethodWriter writer, IType type) throws BytecodeException {
    }

    public void toString(@NonNull String indent, @NonNull StringBuilder buffer) {
        buffer.append(this.text);
    }
}

