/*
 * Decompiled with CFR 0.152.
 */
package dyvilx.tools.gensrc.ast;

import dyvil.annotation.internal.NonNull;
import dyvil.lang.Name;
import dyvil.source.FileSource;
import dyvilx.tools.compiler.DyvilCompiler;
import dyvilx.tools.compiler.ast.attribute.AttributeList;
import dyvilx.tools.compiler.ast.classes.ClassBody;
import dyvilx.tools.compiler.ast.classes.CodeClass;
import dyvilx.tools.compiler.ast.classes.IClass;
import dyvilx.tools.compiler.ast.expression.IValue;
import dyvilx.tools.compiler.ast.expression.access.ConstructorCall;
import dyvilx.tools.compiler.ast.expression.access.FieldAccess;
import dyvilx.tools.compiler.ast.expression.access.MethodCall;
import dyvilx.tools.compiler.ast.expression.constant.StringValue;
import dyvilx.tools.compiler.ast.field.IDataMember;
import dyvilx.tools.compiler.ast.header.ClassUnit;
import dyvilx.tools.compiler.ast.header.ICompilationUnit;
import dyvilx.tools.compiler.ast.header.PackageDeclaration;
import dyvilx.tools.compiler.ast.imports.ImportDeclaration;
import dyvilx.tools.compiler.ast.method.CodeMethod;
import dyvilx.tools.compiler.ast.method.ICallableMember;
import dyvilx.tools.compiler.ast.method.IMethod;
import dyvilx.tools.compiler.ast.method.MatchList;
import dyvilx.tools.compiler.ast.parameter.ArgumentList;
import dyvilx.tools.compiler.ast.parameter.CodeParameter;
import dyvilx.tools.compiler.ast.parameter.IParameter;
import dyvilx.tools.compiler.ast.parameter.ParameterList;
import dyvilx.tools.compiler.ast.statement.StatementList;
import dyvilx.tools.compiler.ast.structure.Package;
import dyvilx.tools.compiler.ast.type.IType;
import dyvilx.tools.compiler.ast.type.builtin.Types;
import dyvilx.tools.compiler.ast.type.compound.ArrayType;
import dyvilx.tools.compiler.parser.DyvilSymbols;
import dyvilx.tools.compiler.sources.FileType;
import dyvilx.tools.gensrc.lang.I18n;
import dyvilx.tools.gensrc.lexer.GenSrcLexer;
import dyvilx.tools.gensrc.parser.BlockParser;
import dyvilx.tools.gensrc.sources.GenSrcFileType;
import dyvilx.tools.parsing.Parser;
import dyvilx.tools.parsing.ParserManager;
import dyvilx.tools.parsing.lexer.Symbols;
import dyvilx.tools.parsing.marker.MarkerList;
import java.io.File;

public class Template
extends ClassUnit {
    private IClass templateClass;
    private IMethod genMethod;
    private IMethod mainMethod;

    public Template(DyvilCompiler compiler, Package pack, File input, File output) {
        super(compiler, pack, input, output);
        this.markers = new MarkerList(I18n.SYNTAX);
    }

    public String getTemplateName() {
        return this.getPackage().getDirectory() + this.fileSource.file().getName();
    }

    public IDataMember resolveField(Name name) {
        IDataMember superField = super.resolveField(name);
        if (superField != null) {
            return superField;
        }
        return LazyTypes.Builtins_CLASS.resolveField(name);
    }

    public void getMethodMatches(MatchList<IMethod> list, IValue receiver, Name name, ArgumentList arguments) {
        super.getMethodMatches(list, receiver, name, arguments);
        if (list.hasCandidate()) {
            return;
        }
        LazyTypes.Builtins_CLASS.getMethodMatches(list, receiver, name, arguments);
    }

    public void tokenize() {
        if (this.load()) {
            this.tokens = new GenSrcLexer(this.markers).tokenize(this.fileSource.text());
        }
    }

    public void parse() {
        CodeClass theClass = new CodeClass(null, this.name, AttributeList.of((long)1L));
        ClassBody classBody = new ClassBody((IClass)theClass);
        theClass.setBody(classBody);
        this.addClass((IClass)theClass);
        this.templateClass = theClass;
        CodeMethod genMethod = new CodeMethod((IClass)theClass, Name.fromRaw((String)"generate"), (IType)Types.VOID, AttributeList.of((long)0x20000001L));
        StatementList directives = new StatementList();
        genMethod.setValue((IValue)directives);
        classBody.addMethod((IMethod)genMethod);
        this.genMethod = genMethod;
        CodeMethod mainMethod = new CodeMethod((IClass)theClass, Name.fromRaw((String)"main"), (IType)Types.VOID, AttributeList.of((long)9L));
        classBody.addMethod((IMethod)mainMethod);
        this.mainMethod = mainMethod;
        new ParserManager((Symbols)DyvilSymbols.INSTANCE, this.tokens.iterator(), this.markers).parse((Parser)new BlockParser(this, directives));
    }

    public void resolveTypes() {
        this.makeGenerateSpecMethod();
        this.makeMainMethod();
        this.packageDeclaration = new PackageDeclaration(null, this.getPackage().getFullName());
        this.templateClass.setSuperType(LazyTypes.Template);
        this.templateClass.setSuperConstructorArguments(new ArgumentList((IValue)new StringValue(this.getTemplateName())));
        super.resolveTypes();
    }

    private void makeMainMethod() {
        ParameterList params = this.mainMethod.getParameters();
        CodeParameter argsParam = new CodeParameter((ICallableMember)this.mainMethod, null, Name.fromRaw((String)"args"), (IType)new ArrayType((IType)Types.STRING));
        params.add((IParameter)argsParam);
        ConstructorCall newTemplate = new ConstructorCall(null, this.templateClass.getClassType(), ArgumentList.EMPTY);
        this.mainMethod.setValue((IValue)new MethodCall(null, (IValue)newTemplate, Name.fromRaw((String)"mainImpl"), new ArgumentList((IValue)new FieldAccess((IDataMember)argsParam))));
    }

    private void makeGenerateSpecMethod() {
        ParameterList params = this.genMethod.getParameters();
        CodeParameter specParam = new CodeParameter((ICallableMember)this.genMethod, null, Name.fromRaw((String)"spec"), LazyTypes.Specialization);
        CodeParameter writerParam = new CodeParameter((ICallableMember)this.genMethod, null, Name.fromRaw((String)"writer"), LazyTypes.Writer);
        params.add((IParameter)specParam);
        params.add((IParameter)writerParam);
        this.genMethod.getExceptions().add(LazyTypes.IOException);
    }

    protected boolean printMarkers() {
        return ICompilationUnit.printMarkers((DyvilCompiler)this.compiler, (MarkerList)this.markers, (FileType)GenSrcFileType.TEMPLATE, (Name)this.name, (FileSource)this.fileSource);
    }

    public void toString(@NonNull String indent, @NonNull StringBuilder buffer) {
        for (int i = 0; i < this.importCount; ++i) {
            buffer.append(indent);
            Template.appendImport(indent, buffer, this.importDeclarations[i]);
            buffer.append('\n');
        }
        IValue directives = this.genMethod.getValue();
        if (!(directives instanceof StatementList)) {
            directives.toString(indent, buffer);
            return;
        }
        StatementList statements = (StatementList)directives;
        int count = statements.size();
        for (int i = 0; i < count; ++i) {
            statements.get(i).toString(indent, buffer);
            buffer.append('\n');
        }
    }

    public static void appendImport(@NonNull String indent, @NonNull StringBuilder buffer, ImportDeclaration importDeclaration) {
        buffer.append('#');
        int position = buffer.length() + "import".length();
        importDeclaration.toString(indent, buffer);
        buffer.setCharAt(position, '(');
        buffer.append(')');
    }

    public static class LazyTypes {
        public static final Package dyvilxToolsGensrc = Package.rootPackage.resolveGlobalPackage("dyvilx/tools/gensrc");
        public static final IType Writer = Package.javaIO.resolveClass("Writer").getClassType();
        public static final IType StringWriter = Package.javaIO.resolveClass("StringWriter").getClassType();
        public static final IType IOException = Package.javaIO.resolveClass("IOException").getClassType();
        public static final IType Specialization = dyvilxToolsGensrc.resolveClass("Specialization").getClassType();
        public static final IType Template = dyvilxToolsGensrc.resolveClass("Template").getClassType();
        public static final IClass Builtins_CLASS = dyvilxToolsGensrc.resolveClass("Builtins");
    }
}

