/*
 * Decompiled with CFR 0.152.
 */
package dyvilx.tools.gensrc;

import dyvilx.tools.compiler.DyvilCompiler;
import dyvilx.tools.compiler.config.CompilerConfig;
import dyvilx.tools.compiler.sources.DyvilFileType;
import dyvilx.tools.gensrc.GenSrcConfig;
import dyvilx.tools.gensrc.ast.Template;
import dyvilx.tools.gensrc.sources.GenSrcFileType;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class GenSrc
extends DyvilCompiler {
    private List<File> specs = new ArrayList<File>();
    private List<Template> templates = new ArrayList<Template>();

    protected CompilerConfig createConfig() {
        return new GenSrcConfig(this);
    }

    protected void setupFileFinder() {
        this.fileFinder.registerFileType(".dgt", GenSrcFileType.TEMPLATE);
        this.fileFinder.registerFileType(".dgs", GenSrcFileType.SPEC);
        this.fileFinder.registerFileType(".dgc", DyvilFileType.DYVIL_UNIT);
        this.fileFinder.registerFileType(".dgh", DyvilFileType.DYVIL_HEADER);
    }

    public void addSpec(File file) {
        this.specs.add(file);
    }

    public void addTemplate(Template template) {
        this.templates.add(template);
    }

    public void test() {
        if (this.config.getMainType() != null) {
            super.test();
            return;
        }
        this.config.setMainType("dyvilx.tools.gensrc.Runner");
        List mainArgs = this.config.getMainArgs();
        mainArgs.clear();
        for (File sourceDir : this.config.sourceDirs) {
            mainArgs.add("source_dir=" + sourceDir);
        }
        mainArgs.add("output_dir=" + ((GenSrcConfig)this.config).getGenSrcDir());
        for (Template template : this.templates) {
            String templateName = template.getTemplateName();
            mainArgs.add("-t");
            mainArgs.add(template.getFullName());
            for (File spec : this.specs) {
                String specName = spec.getPath();
                if (!dyvilx.tools.gensrc.Template.nameMatches((String)templateName, (String)specName)) continue;
                mainArgs.add(specName);
            }
        }
        super.test();
    }
}

