/*
 * Decompiled with CFR 0.152.
 */
package org.duelengine.merge.maven;

import java.util.Arrays;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.duelengine.merge.MergeBuilder;

public class MergeMojo
extends AbstractMojo {
    private String webappDir;
    private String outputDir;
    private String resourcesDir;
    private String cdnRoot;
    private String cdnMapFile;
    private String cdnFiles;

    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        log.info((CharSequence)("\twebappDir=" + this.webappDir));
        log.info((CharSequence)("\toutputDir=" + this.outputDir));
        if (this.cdnMapFile == null || this.cdnMapFile.isEmpty()) {
            this.cdnMapFile = "/cdn.properties";
        } else if (!this.cdnMapFile.startsWith("/")) {
            this.cdnMapFile = '/' + this.cdnMapFile;
        }
        log.info((CharSequence)("\tcdnMapFile=" + this.resourcesDir + this.cdnMapFile));
        log.info((CharSequence)("\tcdnRoot=" + this.cdnRoot));
        Object[] exts = this.cdnFiles != null ? this.cdnFiles.split("[|,\\s]+") : new String[]{};
        log.info((CharSequence)("\tcdnFiles=" + Arrays.toString(exts)));
        MergeBuilder merger = new MergeBuilder((String[])exts);
        merger.setWebAppDir(this.webappDir);
        merger.setOutputDir(this.outputDir);
        if (this.cdnRoot != null && !this.cdnRoot.isEmpty()) {
            merger.setCDNRoot(this.cdnRoot);
        }
        merger.setCDNMapFile(this.resourcesDir + this.cdnMapFile);
        try {
            merger.execute();
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }
}

