/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.xml;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerException;
import org.dstadler.commons.logging.jdk.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class XMLHelper {
    static final String FEATURE_LOAD_DTD_GRAMMAR = "http://apache.org/xml/features/nonvalidating/load-dtd-grammar";
    static final String FEATURE_LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    static final String FEATURE_DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";
    static final String FEATURE_EXTERNAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    static final String PROPERTY_ENTITY_EXPANSION_LIMIT = "http://www.oracle.com/xml/jaxp/properties/entityExpansionLimit";
    static final String PROPERTY_SECURITY_MANAGER = "http://apache.org/xml/properties/security-manager";
    static final String METHOD_ENTITY_EXPANSION_XERCES = "setEntityExpansionLimit";
    static final String[] SECURITY_MANAGERS = new String[]{"org.apache.xerces.util.SecurityManager"};
    private static final Logger LOG = LoggerFactory.make();
    private static long lastLog;

    private XMLHelper() {
    }

    public static SAXParserFactory getSAXParserFactory() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        XMLHelper.trySet(factory::setFeature, "http://javax.xml.XMLConstants/feature/secure-processing", true);
        XMLHelper.trySet(factory::setFeature, FEATURE_LOAD_DTD_GRAMMAR, false);
        XMLHelper.trySet(factory::setFeature, FEATURE_LOAD_EXTERNAL_DTD, false);
        XMLHelper.trySet(factory::setFeature, FEATURE_EXTERNAL_ENTITIES, false);
        XMLHelper.trySet(factory::setFeature, FEATURE_DISALLOW_DOCTYPE_DECL, true);
        return factory;
    }

    public static XMLReader newXMLReader() throws IOException {
        XMLReader xmlReader;
        block5: {
            block4: {
                try {
                    xmlReader = XMLHelper.getSAXParserFactory().newSAXParser().getXMLReader();
                }
                catch (ParserConfigurationException | SAXException e) {
                    throw new IOException(e);
                }
                xmlReader.setEntityResolver(XMLHelper::ignoreEntity);
                XMLHelper.trySet(xmlReader::setFeature, "http://javax.xml.XMLConstants/feature/secure-processing", true);
                XMLHelper.trySet(xmlReader::setFeature, FEATURE_EXTERNAL_ENTITIES, false);
                Object manager = XMLHelper.getXercesSecurityManager();
                if (manager == null) break block4;
                if (XMLHelper.trySet(xmlReader::setProperty, PROPERTY_SECURITY_MANAGER, manager)) break block5;
            }
            XMLHelper.trySet(xmlReader::setProperty, PROPERTY_ENTITY_EXPANSION_LIMIT, 1);
        }
        return xmlReader;
    }

    private static Object getXercesSecurityManager() {
        for (String securityManagerClassName : SECURITY_MANAGERS) {
            try {
                Object mgr = Class.forName(securityManagerClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
                Method setLimit = mgr.getClass().getMethod(METHOD_ENTITY_EXPANSION_XERCES, Integer.TYPE);
                setLimit.invoke(mgr, 1);
                return mgr;
            }
            catch (ClassNotFoundException mgr) {
            }
            catch (Throwable e) {
                XMLHelper.logThrowable(e, "SAX Feature unsupported", securityManagerClassName);
            }
        }
        return null;
    }

    private static boolean trySet(SecurityFeature feature, String name, boolean value) {
        try {
            feature.accept(name, value);
            return true;
        }
        catch (Exception e) {
            XMLHelper.logThrowable(e, "SAX Feature unsupported", name);
        }
        catch (Error ame) {
            XMLHelper.logThrowable(ame, "Cannot set SAX feature because outdated XML parser in classpath", name);
        }
        return false;
    }

    private static boolean trySet(SecurityProperty property, String name, Object value) {
        try {
            property.accept(name, value);
            return true;
        }
        catch (Exception e) {
            XMLHelper.logThrowable(e, "SAX Feature unsupported", name);
        }
        catch (Error ame) {
            XMLHelper.logThrowable(ame, "Cannot set SAX feature because outdated XML parser in classpath", name);
        }
        return false;
    }

    private static void logThrowable(Throwable t, String message, String name) {
        if (System.currentTimeMillis() > lastLog + TimeUnit.MINUTES.toMillis(5L)) {
            LOG.log(Level.WARNING, message + " [log suppressed for 5 minutes] " + name, t);
            lastLog = System.currentTimeMillis();
        }
    }

    private static InputSource ignoreEntity(String publicId, String systemId) {
        return new InputSource(new StringReader(""));
    }

    @FunctionalInterface
    private static interface SecurityProperty {
        public void accept(String var1, Object var2) throws SAXException;
    }

    @FunctionalInterface
    private static interface SecurityFeature {
        public void accept(String var1, boolean var2) throws ParserConfigurationException, SAXException, TransformerException;
    }
}

