/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.dstadler.commons.logging.jdk.LoggerFactory;

public class ExecutorUtil {
    private static final Logger log = LoggerFactory.make();

    public static ThreadFactory createThreadFactory(String namePattern) {
        return new BasicThreadFactory.Builder().daemon(true).namingPattern(namePattern).uncaughtExceptionHandler((t, e) -> log.log(Level.WARNING, "Unexpected Exception caught in thread " + t.getName(), e)).build();
    }

    public static void shutdownAndAwaitTermination(ExecutorService executor, long timeoutMs) {
        executor.shutdown();
        try {
            if (!executor.awaitTermination(timeoutMs, TimeUnit.MILLISECONDS)) {
                executor.shutdownNow();
                if (!executor.awaitTermination(timeoutMs, TimeUnit.MILLISECONDS)) {
                    log.info("Executor did not shutdown cleanly in the given timeout of 10 seconds before cancelling current jobs and 10 seconds after cancelling jobs");
                }
            }
        }
        catch (InterruptedException ie) {
            executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public static Thread lookupThread(String contains) {
        int count = Thread.currentThread().getThreadGroup().activeCount();
        Thread[] threads = new Thread[count];
        Thread.currentThread().getThreadGroup().enumerate(threads);
        for (Thread t : threads) {
            if (t == null || !t.getName().contains(contains)) continue;
            return t;
        }
        return null;
    }
}

