/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.SystemUtils;
import org.dstadler.commons.util.ClientConstants;

public class DocumentStarter {
    private static final Logger logger = Logger.getLogger(DocumentStarter.class.getName());
    public static final String PROPERTY_DOCUMENT_STARTER_DISABLE = "org.dstadler.commons.util.DocumentStarter.disable";

    public void openFile(File file) {
        try {
            String fileString = file.toString();
            if (this.checkForBadFileName(fileString)) {
                this.openURL(file.getCanonicalPath());
            } else {
                logger.info("Opening document " + file.toURI().toURL());
                this.openURL(file.toURI().toURL());
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Exception occurred while opening file: " + file, e);
        }
    }

    private boolean checkForBadFileName(String url) {
        boolean bad = false;
        if (url.startsWith("\\\\")) {
            bad = true;
        } else if (url.contains("&")) {
            bad = true;
        } else if (url.contains("[")) {
            bad = true;
        } else if (url.contains("]")) {
            bad = true;
        } else if (url.contains("(")) {
            bad = true;
        } else if (url.contains(")")) {
            bad = true;
        } else if (url.contains("+")) {
            bad = true;
        } else if (url.contains("\u00b4")) {
            bad = true;
        } else if (url.contains("`")) {
            bad = true;
        }
        return bad;
    }

    public void openURL(URL url) throws IOException {
        String href = url.toString();
        this.openURL(href);
    }

    public void openURL(String url) throws IOException {
        logger.info("Opening url " + url);
        Object href = url;
        if (((String)href).startsWith("file:")) {
            href = ((String)href).substring(5);
            while (((String)href).startsWith("/")) {
                href = ((String)href).substring(1);
            }
            href = "file:///" + (String)href;
        }
        if (DocumentStarter.isDisabledForTest()) {
            logger.info("Not showing document '" + (String)href + "', system property for test is set");
            return;
        }
        String localHref = href;
        if (SystemUtils.IS_OS_UNIX) {
            try {
                Runtime.getRuntime().exec("xdg-open " + (String)href);
            }
            catch (IOException e1) {
                try {
                    Runtime.getRuntime().exec("gnome-open " + (String)href);
                }
                catch (IOException e2) {
                    try {
                        Runtime.getRuntime().exec("kde-open " + (String)href);
                    }
                    catch (IOException e3) {
                        Runtime.getRuntime().exec("kde-open5 " + (String)href);
                    }
                }
            }
        } else {
            Runtime.getRuntime().exec((String[])ArrayUtils.addAll((Object[])ClientConstants.CMD_C_START_ARRAY, (Object[])new String[]{localHref.replace("&", "^&")}));
        }
    }

    public static boolean isDisabledForTest() {
        return "true".equalsIgnoreCase(System.getProperty(PROPERTY_DOCUMENT_STARTER_DISABLE));
    }
}

