/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.thread;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dstadler.commons.logging.jdk.LoggerFactory;
import org.dstadler.commons.util.SuppressForbidden;

public class ThreadUtils {
    private static final Logger log = LoggerFactory.make();

    public static List<Thread> getThreadsByName(String threadName) {
        int count = Thread.currentThread().getThreadGroup().activeCount();
        Thread[] threads = new Thread[count];
        Thread.currentThread().getThreadGroup().enumerate(threads);
        ArrayList<Thread> foundThreads = new ArrayList<Thread>();
        for (Thread t : threads) {
            if (t == null || !t.getName().equals(threadName)) continue;
            foundThreads.add(t);
        }
        return foundThreads;
    }

    public static Thread lookupThread(String contains) {
        int count = Thread.currentThread().getThreadGroup().activeCount();
        Thread[] threads = new Thread[count];
        Thread.currentThread().getThreadGroup().enumerate(threads);
        for (Thread t : threads) {
            if (t == null || !t.getName().contains(contains)) continue;
            return t;
        }
        return null;
    }

    @SuppressForbidden(reason="This method calls Thread.stop by definition")
    public static void stopThread(Thread thread, int joinTimeMs) throws InterruptedException {
        thread.join(1000L);
        thread.interrupt();
        try {
            thread.join(joinTimeMs);
        }
        catch (InterruptedException e) {
            log.log(Level.WARNING, "Joining thread was interrupted", e);
        }
        try {
            thread.stop();
        }
        catch (ThreadDeath | UnsupportedOperationException e) {
            log.log(Level.WARNING, "Stopping thread threw an exception", e);
        }
    }
}

