/*
 * Decompiled with CFR 0.152.
 */
package org.dstadler.commons.selenium;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.dstadler.commons.exec.ExecutionHelper;
import org.dstadler.commons.logging.jdk.LoggerFactory;
import org.dstadler.commons.util.SuppressForbidden;
import org.dstadler.commons.zip.ZipUtils;

public class ChromeDriverUtils {
    private static final Logger log = LoggerFactory.make();
    public static final String PROPERTY_CHROME_DRIVER = "webdriver.chrome.driver";
    public static final String VERSION_JSON = "https://googlechromelabs.github.io/chrome-for-testing/known-good-versions-with-downloads.json";

    public static void configureMatchingChromeDriver() throws IOException {
        ChromeDriverUtils.configureMatchingChromeDriver(ChromeDriverUtils.getGoogleChromeVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configureMatchingChromeDriver(String chromeVersion) throws IOException {
        String downloadUrl;
        ChromeDriverUtils.checkState(StringUtils.isNotBlank((CharSequence)chromeVersion), "Need a version of chrome to configure, but had '" + chromeVersion + "'");
        String versionUrl = ChromeDriverUtils.getVersionUrl(chromeVersion);
        String driverVersion = null;
        try {
            try {
                driverVersion = IOUtils.toString((URL)new URL(versionUrl), (Charset)StandardCharsets.UTF_8);
                ChromeDriverUtils.checkState(StringUtils.isNotBlank((CharSequence)driverVersion), "Did not find a chrome-driver-version for " + chromeVersion + " at " + versionUrl);
                downloadUrl = SystemUtils.IS_OS_WINDOWS ? "https://chromedriver.storage.googleapis.com/" + driverVersion + "/chromedriver_win32.zip" : "https://chromedriver.storage.googleapis.com/" + driverVersion + "/chromedriver_linux64.zip";
            }
            catch (FileNotFoundException e) {
                String versionJson = IOUtils.toString((URL)new URL(VERSION_JSON), (Charset)StandardCharsets.UTF_8);
                Matcher matcher = Pattern.compile("https://edgedl.me.gvt1.com/edgedl/chrome/chrome-for-testing/(" + chromeVersion + "[0-9.]+)/linux64/chromedriver-linux64.zip").matcher(versionJson);
                while (matcher.find()) {
                    driverVersion = matcher.group(1);
                }
                if (driverVersion == null) {
                    throw new IOException("Failed for https://googlechromelabs.github.io/chrome-for-testing/known-good-versions-with-downloads.json and " + versionJson + ", previous exception: " + e);
                }
                ChromeDriverUtils.checkState(StringUtils.isNotBlank((CharSequence)driverVersion), "Did not find a chrome-driver-version for " + chromeVersion + " at " + versionUrl);
                downloadUrl = SystemUtils.IS_OS_WINDOWS ? "https://edgedl.me.gvt1.com/edgedl/chrome/chrome-for-testing/" + driverVersion + "/win64/chromedriver-win64.zip" : "https://edgedl.me.gvt1.com/edgedl/chrome/chrome-for-testing/" + driverVersion + "/linux64/chromedriver-linux64.zip";
            }
        }
        catch (IOException e) {
            throw new IOException("Failed for " + versionUrl, e);
        }
        File chromeDriverFile = new File("chromedriver-" + driverVersion + (SystemUtils.IS_OS_WINDOWS ? ".exe" : ""));
        if (!chromeDriverFile.exists()) {
            log.info("Downloading matching chromedriver from " + downloadUrl + " and extracting to " + chromeDriverFile);
            File fileZip = File.createTempFile("chromedriver", ".zip");
            try {
                FileUtils.copyURLToFile((URL)new URL(downloadUrl), (File)fileZip);
                ZipUtils.extractZip(fileZip, new File("."));
                try {
                    FileUtils.moveFile((File)new File("chromedriver" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : "")), (File)chromeDriverFile);
                }
                catch (FileNotFoundException e) {
                    FileUtils.moveFile((File)new File(SystemUtils.IS_OS_WINDOWS ? "chromedriver-win64/chromedriver.exe" : "chromedriver-linux64/chromedriver"), (File)chromeDriverFile);
                }
            }
            finally {
                FileUtils.delete((File)fileZip);
                FileUtils.deleteDirectory((File)new File("chromedriver-win64"));
                FileUtils.deleteDirectory((File)new File("chromedriver-linux64"));
            }
        }
        if (!chromeDriverFile.canExecute() && !chromeDriverFile.setExecutable(true)) {
            throw new IOException("Could not make binary " + chromeDriverFile + " executable.");
        }
        log.info("Using chromedriver from " + chromeDriverFile.getAbsolutePath());
        System.setProperty(PROPERTY_CHROME_DRIVER, chromeDriverFile.getAbsolutePath());
    }

    protected static String getVersionUrl(String chromeVersion) {
        return "https://chromedriver.storage.googleapis.com/LATEST_RELEASE_" + chromeVersion;
    }

    protected static String getGoogleChromeVersion() throws IOException {
        String version;
        CommandLine cmdLine;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (SystemUtils.IS_OS_WINDOWS) {
            cmdLine = new CommandLine("reg");
            cmdLine.addArgument("query");
            cmdLine.addArgument("\"HKEY_CURRENT_USER\\Software\\Google\\Chrome\\BLBeacon\"");
            cmdLine.addArgument("/v");
            cmdLine.addArgument("version");
            ExecutionHelper.getCommandResultIntoStream(cmdLine, new File("."), 0, 10000L, out);
            version = out.toString().replace("HKEY_CURRENT_USER\\Software\\Google\\Chrome\\BLBeacon", "").replace("version", "").replace("REG_SZ", "").trim();
        } else {
            cmdLine = new CommandLine("google-chrome-stable");
            cmdLine.addArgument("--version");
            try {
                ExecutionHelper.getCommandResultIntoStream(cmdLine, new File("."), 0, 10000L, out);
                version = StringUtils.removeStart((String)out.toString(), (String)"Google Chrome ").trim();
            }
            finally {
                out.close();
                log.info("Having result from calling '" + cmdLine + "': " + out.toString(StandardCharsets.UTF_8).trim());
            }
        }
        try {
            version = version.substring(0, version.lastIndexOf(46));
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed for '" + out + "'", e);
        }
        log.info("Found Google Chrome version '" + version + "' from running with --version: '" + out.toString().trim() + "'");
        return version;
    }

    @SuppressForbidden(reason="This is provided on purpose here")
    protected static void cleanUp() {
        System.clearProperty(PROPERTY_CHROME_DRIVER);
    }

    private static void checkState(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalStateException(String.valueOf(errorMessage));
        }
    }
}

